#ifndef FORM_H
#define FORM_H

#include <QWidget>
#include <qdatetime.h>
#include <QSettings>
#include <Phonon/AudioOutput>
#include <Phonon/MediaObject>
#include <Phonon/Path>
#include <Phonon/BackendCapabilities>
#include "settings.h"

namespace Ui {
    class Form;
}

class Form : public QWidget {
    Q_OBJECT
public:
    Form(QWidget *parent = 0);
    ~Form();

protected:
    void changeEvent(QEvent *e);
    

private:
    Ui::Form *ui;
    Settings *settingsDialog;
    QSettings mSettings;
    QTimer *mvpTimer;
    QTime mvTime;
    Phonon::MediaObject *mediaObject;
    Phonon::AudioOutput *audioOutput;
    Phonon::Path mediaPath;
    int mvCountDown;
    int mvStarted;
    bool mvTimeUp;

    void syncSettings();
    void formatTimer(int timerSeconds);
    void setTimer(int timerSeconds);
    void changeTimer(bool addTime, int amountSeconds);
    void timeUp();
    void timerColour(bool timerRed);

private slots:
    void on_Form_customContextMenuRequested(QPoint pos);
    void on_pushButton_start_clicked();
    void on_pushButton_reset_clicked();
    void on_pushButton_minutes_plus_clicked();
    void on_pushButton_minutes_minus_clicked();
    void on_pushButton_seconds_plus_clicked();
    void on_pushButton_seconds_minus_clicked();
    void on_pushButton_mem_1_clicked();
    void on_pushButton_mem_2_clicked();
    void on_pushButton_mem_3_clicked();
    void on_pushButton_mem_4_clicked();
    void on_pushButton_settings_clicked();


public slots:
    void update();
};

#endif // FORM_H
