/*
 * Copyright (C) 2010 Nokia Corporation
 *   @author Mathias Hasselmann <mathias.hasselmann@maemo.org>
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include <libosso-abook/osso-abook.h>

#include "merger-window.h"

typedef struct
{
    OssoABookMenuExtension parent_instance;
} ContactsMergerExtension;

typedef struct
{
    OssoABookMenuExtensionClass parent_class;
} ContactsMergerExtensionClass;

G_GNUC_INTERNAL GType
contacts_merger_extension_get_type (void) G_GNUC_CONST;

OSSO_ABOOK_DEFINE_MENU_PLUGIN (ContactsMergerExtension,
        contacts_merger_extension, OSSO_ABOOK_TYPE_MENU_EXTENSION,,);

static void
contacts_merger_extension_init (ContactsMergerExtension *self)
{
}

static void
find_duplicates_cb (GtkWidget *widget,
        gpointer   user_data)
{
    OssoABookRoster *aggregator;
    GtkWidget *window;

    aggregator = osso_abook_aggregator_get_default (NULL);
    window = merger_window_new (OSSO_ABOOK_AGGREGATOR (aggregator));
    gtk_widget_show (window);
}

static OssoABookMenuEntry entries[] = {
    { "Find duplicate contacts", 0, 0,
      G_CALLBACK (find_duplicates_cb), NULL },
};

static const OssoABookMenuEntry *
get_menu_entries (OssoABookMenuExtension *ext)
{
    return entries;
}

static int
get_n_menu_entries (OssoABookMenuExtension *ext)
{
    return G_N_ELEMENTS (entries);
}

static void
contacts_merger_extension_class_init (ContactsMergerExtensionClass *cls)
{
    OssoABookMenuExtensionClass *ext_class;

    ext_class = OSSO_ABOOK_MENU_EXTENSION_CLASS (cls);
    ext_class->get_n_menu_entries = get_n_menu_entries;
    ext_class->get_menu_entries = get_menu_entries;
    ext_class->name =  OSSO_ABOOK_MENU_NAME_MAIN_VIEW;
}

static void
contacts_merger_extension_class_finalize (ContactsMergerExtensionClass *cls)
{
}

