/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __MERGER_H__
#define __MERGER_H__

#include <glib.h>
#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS
 
#define TYPE_MATCH          match_get_type ()
#define TYPE_MATCH_LIST     match_list_get_type ()

typedef struct _Match Match;

typedef void (*MergeFinishedCb) (gint      merged_count,
                                 gint      failed_count,
                                 GList    *failed,
                                 gpointer  user_data);

GType          match_get_type               (void) G_GNUC_CONST;
Match         *match_ref                    (Match              *match);
void           match_unref                  (Match              *match);
void           match_get_contacts           (Match              *match,
                                             OssoABookContact  **contact1,
                                             OssoABookContact  **contact2);
const gchar   *match_get_description        (Match              *match);
gint           match_get_score              (Match              *score);

GType          match_list_get_type          (void) G_GNUC_CONST;
void           match_list_free              (GList              *matches);
GList         *match_list_copy              (GList              *matches);

GList         *generate_merge_suggestions   (GList              *contacts,
                                             GList              *im_fields);

void           merge_contacts               (GList              *matches,
                                             GtkWindow          *parent,
                                             MergeFinishedCb     cb,
                                             gpointer            user_data);

G_END_DECLS

#endif /* __MERGER_H__ */
