/*
 *  connectnow home widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef CONNECTNOW_SETTINGS_DIALOG_H
#define CONNECTNOW_SETTINGS_DIALOG_H
#include <gtk/gtk.h>

static const int NUM_PREDEFINED_ICONS = 7;
static const int CONNECT = 0;
static const int DISCONNECT = 1;
static const int LABEL = 2;

static const gchar* _predefined_icons[][3] =
{
  {"connectnow_general_connected", "connectnow_general_disconnected", "General"},
  {"connectnow_gprs_connected_net", "connectnow_gprs_disconnected_net", "Net"},
  {"connectnow_gprs_connected_mms", "connectnow_gprs_disconnected_mms", "MMS"},
  {"connectnow_wifi_connected_home", "connectnow_wifi_disconnected_home", "Home"},
  {"connectnow_wifi_connected_work", "connectnow_wifi_disconnected_work", "Work"},
  {"connectnow_usb_connected", "connectnow_usb_disconnected", "USB"},
  {"connectnow_bt_connected", "connectnow_bt_disconnected", "Bluetooth"}
};

typedef struct _icon_data icon_data_t;

struct _icon_data
{
  GtkWidget* connect_icon;
  GtkWidget* disconnect_icon;
  gchar* connect_name;
  gchar* disconnect_name;
};

typedef struct _custom_icon custom_icon_data;

struct _custom_icon
{
  GtkWidget* icon_button;
  gchar* icon_name;
};

void
select_and_set_icon(GtkButton* button, custom_icon_data* data);
void
connect_now_show_icon_selector(GtkButton* button, icon_data_t* icon_data);
#endif
