/*
 *  connectnow home widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "connectnow-load-and-store.h"
#define CONNECTNOW_HOME_PLUGIN_SETTINGS_FILE "/.connectnow_home_widget"


void 
read_settings(ConnectNowHomePlugin *desktop_plugin)
{
  GKeyFile *keyFile;
  gchar* fileName;
  gboolean fileExists;

  keyFile = g_key_file_new();
  fileName = g_strconcat(g_get_home_dir(), CONNECTNOW_HOME_PLUGIN_SETTINGS_FILE, NULL);
  fileExists = g_key_file_load_from_file (keyFile, fileName, G_KEY_FILE_KEEP_COMMENTS, NULL);
  if(fileExists)
  {
    GError *error = NULL;
    if(g_key_file_has_key(keyFile, desktop_plugin->iD, "widget_size", NULL))
    {
      desktop_plugin->widget_size = g_key_file_get_integer(keyFile, desktop_plugin->iD, "widget_size", NULL);
    }
    if(g_key_file_has_key(keyFile, desktop_plugin->iD, "hide_connection_name", NULL))
    {
      desktop_plugin->hide_connection_name = g_key_file_get_boolean(keyFile, desktop_plugin->iD, "hide_connection_name", NULL);
    }
    if(g_key_file_has_key(keyFile, desktop_plugin->iD, "connectedIcon", NULL))
    {
      desktop_plugin->connectedImageName = g_key_file_get_string(keyFile, desktop_plugin->iD, "connectedIcon", NULL);
    }
    else
    {
      desktop_plugin->connectedImageName = g_strdup(GENERAL_CONNECTED);
    }
    if(g_key_file_has_key(keyFile, desktop_plugin->iD, "disconnectedIcon", NULL))
    {
      desktop_plugin->disconnectedImageName = g_key_file_get_string(keyFile, desktop_plugin->iD, "disconnectedIcon", NULL);
    }
    else
    {
      desktop_plugin->disconnectedImageName = g_strdup(GENERAL_DISCONNECTED);
    }
    desktop_plugin->connectedImage = load_image(desktop_plugin->connectedImageName);
    desktop_plugin->disconnectedImage = load_image(desktop_plugin->disconnectedImageName);
    desktop_plugin->connection_name = g_key_file_get_string(keyFile, desktop_plugin->iD, "connection_name", &error);
    if(!error)
    {
      desktop_plugin->connection_id = g_key_file_get_string(keyFile, desktop_plugin->iD, "connection_id", &error);

      if(!error)
      {
	g_key_file_free(keyFile);
	g_free(fileName);
	return;
      }
    }
    g_error_free(error);
    error = NULL;
  }
  desktop_plugin->connection_name = NULL;
  desktop_plugin->connection_id = NULL;
  g_key_file_free(keyFile);
  g_free(fileName);
}

void
connect_now_save_settings(ConnectNowHomePlugin* desktop_plugin)
{
  GKeyFile *keyFile;
  gchar *fileData;
  FILE *iniFile;
  gsize size;
  gchar *filename;
  
  keyFile = g_key_file_new();
  filename = g_strconcat (g_get_home_dir(), CONNECTNOW_HOME_PLUGIN_SETTINGS_FILE, NULL);
  g_key_file_load_from_file (keyFile, filename, G_KEY_FILE_KEEP_COMMENTS, NULL);
  if(desktop_plugin->connection_id)
    g_key_file_set_string(keyFile, desktop_plugin->iD, "connection_id", desktop_plugin->connection_id);
  if(desktop_plugin->connection_name)
    g_key_file_set_string(keyFile, desktop_plugin->iD, "connection_name", desktop_plugin->connection_name);
  
  g_key_file_set_integer(keyFile, desktop_plugin->iD, "widget_size", desktop_plugin->widget_size);
  g_key_file_set_boolean(keyFile, desktop_plugin->iD, "hide_connection_name", desktop_plugin->hide_connection_name);
  if(desktop_plugin->connectedImageName)
  {
    g_key_file_set_string(keyFile, desktop_plugin->iD, "connectedIcon", desktop_plugin->connectedImageName);
  }
  else
  {
    g_key_file_remove_key(keyFile, desktop_plugin->iD, "connectedIcon", NULL);
  }
  if(desktop_plugin->disconnectedImageName)
  {
    g_key_file_set_string(keyFile, desktop_plugin->iD, "disconnectedIcon", desktop_plugin->disconnectedImageName);
  }
  else
  {
    g_key_file_remove_key(keyFile, desktop_plugin->iD, "disconnectedIcon", NULL);
  }
  fileData = g_key_file_to_data (keyFile, &size, NULL);
  g_file_set_contents(filename, fileData, size, NULL);

  g_key_file_free (keyFile); 
  g_free (fileData); 
  g_free (filename); 
}

GdkPixbuf* 
load_image(const gchar* image_name)
{
  GdkPixbuf* image = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(),
					      image_name,
					      CONNECTNOW_DEFAULT_WIDGET_WIDTH,
					      0,
					      NULL);
  if(image == NULL)
  {
    image = gdk_pixbuf_new_from_file_at_scale(image_name,
					      CONNECTNOW_DEFAULT_WIDGET_WIDTH,
					      CONNECTNOW_DEFAULT_WIDGET_WIDTH,
					      FALSE,
					      NULL);
  }
  if(image == NULL)
  {
    gchar* fullpath = g_strdup_printf("/usr/share/icons/hicolor/96x96/hildon/%s.png", image_name);
    image = gdk_pixbuf_new_from_file_at_scale(fullpath,
					      CONNECTNOW_DEFAULT_WIDGET_WIDTH,
					      CONNECTNOW_DEFAULT_WIDGET_WIDTH,
					      FALSE,
					      NULL);
    g_free(fullpath);
  }
  if(image == NULL)
  {
    g_warning("warning can not load icon %s",image_name);
  }

  return image;
}
