#include "SpeedGraph.h"

#include <QPainter>

class SpeedGraphPrivate
{
public:
    ColumbusModel *model;
};

SpeedGraph::SpeedGraph(QWidget *parent)
    : AbstractChart(parent)
{
    this->d = new SpeedGraphPrivate;
    d->model = NULL;

    this->setLabel(tr("Speed Profile"));
}

ColumbusModel* SpeedGraph::model() const
{
    return d->model;
}

void SpeedGraph::setModel(ColumbusModel *model)
{
    d->model = model;
}

void SpeedGraph::paintEvent(QPaintEvent*)
{
    const int width = this->width();
    int height = this->height();

    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);

    painter.setPen(QPen(QColor(0xff, 0xff, 0xff), 1.0f));
    painter.setFont(QFont(painter.font().family(), 10));
    QRect rect = painter.boundingRect(0, 0, 0, 0, 0, this->label());
    painter.drawText(width / 2 - (rect.width() / 2), height - rect.height(),
                     rect.width(), rect.height(),
                     0,
                     this->label());

    height = height - rect.height() - 2;

    painter.setViewport(0, 0, width, height);
    painter.setWindow(0, 0, width, height);

    QColor sColor = this->palette().foreground().color();
    painter.setPen(QPen(sColor, 0.5f));

    int m = 12;
    for(int i = 1; i < m; i++)
    {
        painter.drawLine(0, (height / m) * i + height % m, width, (height / m) * i  + height % m);
    }

    painter.setPen(QPen(this->palette().foreground().color(), 1.0f));
    painter.drawLine(0, height + 1, width, height + 1);

    if(d->model != NULL && d->model->datalog()->count() > 0)
    {
        const qreal max     = d->model->maximumSpeed();
        const qreal scale   = qMax(max, (qreal)100.0f) / (height * 0.9f);

        const int rCount = d->model->datalog()->count();

        qreal pSpeed = d->model->datalog()->last().attribute(QGeoPositionInfo::GroundSpeed);

        for(int i = qMin(rCount, width); i > 0; i--)
        {
            qreal speed = d->model->datalog()->value(rCount - 1 - i).attribute(QGeoPositionInfo::GroundSpeed);

            painter.drawLine(width - i, height - (speed * scale),
                             width - i - 1, height - (speed * scale));

            pSpeed = speed;
        }
    }
}
