#include "AbstractChart.h"

class AbstractChartPrivate
{
public:
    QString label;
};

AbstractChart::AbstractChart(QWidget *parent)
    : QWidget(parent)
{
    this->d = new AbstractChartPrivate;

    d->label = "Abstract Chart";

    QSizePolicy policy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    policy.setHeightForWidth(true);
    this->setSizePolicy(policy);
}

int AbstractChart::heightForWidth(int width) const
{
    return (int)(width * 0.33f);
}

QString AbstractChart::label() const
{
    return d->label;
}

void AbstractChart::setLabel(const QString &label)
{
    d->label = label;
}
