#include "ColumbusDialogWaypointsAverage.h"

#include <QtGui>
#include <QtMaemo5>

class ColumbusDialogWaypointsAveragePrivate
{
public:
    QBoxLayout *bbox;

    QLabel      *status;
    QLineEdit   *name;
    QPushButton *startstop;
};

ColumbusDialogWaypointsAverage::ColumbusDialogWaypointsAverage(QWidget *parent)
    : ColumbusDialog(parent)
{
    this->d = new ColumbusDialogWaypointsAveragePrivate;
    this->setupUi();
}

ColumbusDialogWaypointsAverage::~ColumbusDialogWaypointsAverage()
{
    delete this->d;
}

void ColumbusDialogWaypointsAverage::setupUi()
{
    QVBoxLayout *vbox = new QVBoxLayout(this);

    d->status = new QLabel("Press Start", this);
    d->status->setFixedHeight(96);
    d->status->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    d->bbox = new QBoxLayout(QBoxLayout::LeftToRight);
    d->name = new QLineEdit(this);
    d->startstop = new QPushButton(tr("Start"));

    vbox->addWidget(d->status);
    d->bbox->addWidget(d->name);
    d->bbox->addWidget(d->startstop);
    vbox->addLayout(d->bbox);

    this->setWindowTitle(tr("Average Waypoint"));
}

QString ColumbusDialogWaypointsAverage::name() const
{
    return d->name->text();
}

void ColumbusDialogWaypointsAverage::setName(const QString &name)
{
    d->name->setText(name);
}

QString ColumbusDialogWaypointsAverage::status() const
{
    return d->status->text();
}

void ColumbusDialogWaypointsAverage::setStatus(const QString &status)
{
    d->status->setText(status);
}
