#include <QSettings>
#include <QApplication>

#include "ApplicationController.h"

#include "ui/MainWindow.h"

int main(int argc, char *argv[])
{
    QApplication::setApplicationName(RX_APPLICATION_NAME);
    QApplication::setApplicationVersion(RX_APPLICATION_VERSION);
    QApplication::setOrganizationName("rx");
    QApplication::setOrganizationDomain("rubyx.co.uk");

    QApplication            application (argc, argv);
    ApplicationController   controller;

    MainWindow              window;
    window.initialize(&controller);

    controller.initialize();

#if defined(Q_WS_MAEMO_5)
    window.showFullScreen();
#else
    window.setFixedSize(800, 480);
    window.show();
#endif

    return application.exec();
}
