#include "ColumbusRouteModel.h"

#include <QDebug>
#include <QtSql>

#define CONFIG_KEY_ROUTE_CURRENT "navigation/routes/current"

#define CREATE_ROUTES_TABLE_QUERY "CREATE TABLE IF NOT EXISTS routes (id INTEGER PRIMARY KEY AUTOINCREMENT, name VARCHAR NOT NULL)"

class ColumbusRouteModelPrivate
{
public:
    ColumbusRouteModelPrivate(ColumbusController *controller);

    ColumbusController *controller;

    QModelIndex route;
};

ColumbusRouteModelPrivate::ColumbusRouteModelPrivate(ColumbusController *pController)
    : controller(pController)
{ /* ... */ }

ColumbusRouteModel::ColumbusRouteModel(ColumbusController *controller, QSqlDatabase db)
    : QSqlTableModel(controller, db),
      d(new ColumbusRouteModelPrivate(controller))
{
    QSqlQuery query;

    this->setHeaderData(ColumbusRouteModel::Id, Qt::Horizontal, tr("Id"));
    this->setHeaderData(ColumbusRouteModel::Name, Qt::Horizontal, tr("Name"));

    qDebug() << "ColumbusRouteModel: Checking and updating database scheme if required...";
    if(!query.exec(CREATE_ROUTES_TABLE_QUERY))
    {
        qDebug() << "ColumbusRouteModel: Failed to execute SQL CREATE TABLE query:" << this->lastError().text();
        return;
    }

    this->setTable("routes");
    this->setEditStrategy(QSqlTableModel::OnRowChange);

    if(!this->select())
    {
        qDebug() << "ColumbusRouteModel: Failed to execute SQL SELECT query:" << this->lastError().text();
        return;
    }
    qDebug() << "ColumbusRouteModel: Found" << this->rowCount() << "records";

    int routeId = QSettings().value(CONFIG_KEY_ROUTE_CURRENT, -1).toInt();

    if(routeId != -1)
    {
        for(int i = 0; i < this->rowCount(); i++)
        {
            QModelIndex index = this->index(i, ColumbusRouteModel::Id);
            int id = this->data(index, Qt::DisplayRole).toInt();

            if(id == routeId)
            {
                qDebug() << "ColumbusRouteModel: Loading saved route with id:" << routeId;
                d->route = index;
            }
        }
    }
}

ColumbusRouteModel::~ColumbusRouteModel()
{
    delete this->d;
}
