#include "AbstractCompass.h"

class AbstractCompassPrivate
{
public:
    double heading;
    double bearing;

    bool   isBearingShown;
};

AbstractCompass::AbstractCompass(QWidget *parent)
    : QWidget(parent)
{
    this->d = new AbstractCompassPrivate;
    d->heading = 0.0f;
    d->bearing = 0.0f;
    d->isBearingShown = false;
}

AbstractCompass::~AbstractCompass()
{
    delete this->d;
}

double AbstractCompass::heading() const
{
    return d->heading;
}

void AbstractCompass::setHeading(double heading)
{
    d->heading = heading;
    this->update();

    emit this->headingChanged(heading);
}

double AbstractCompass::bearing() const
{
    return d->bearing;
}

void AbstractCompass::setBearing(double bearing)
{
    d->bearing = bearing;
    this->update();

    emit this->bearingChanged(bearing);
}

bool AbstractCompass::isBearingShown() const
{
    return d->isBearingShown;
}

void AbstractCompass::setBearingShown(bool isShown)
{
    d->isBearingShown = isShown;
    this->update();

    emit this->bearingShownChanged(isShown);
}
