#include "ApplicationController.h"

#include "config.h"

#include <QDebug>

class ApplicationControllerPrivate
{
public:
};

ApplicationController::ApplicationController(QObject *parent)
    : ColumbusController(parent)
{
    this->d = new ApplicationControllerPrivate;
    this->setupConfig();
}

ApplicationController::~ApplicationController()
{
    delete this->d;
}

void ApplicationController::setupConfig()
{
    qDebug() << "ApplicationController: Initializing UI configuration structure.";
    this->config()->addToggle(CONFIG_KEY_DISPLAY_KEEP_ALIVE, tr("Keep-Alive Backlight"), true);

    this->config()->addOption(CONFIG_KEY_DISPLAY_ORIENTATION, tr("Orientation"),
                              QStringList() << tr("Automatic") << tr("Landscape") << tr("Portrait"));
}
