#include "TrackView.h"

#include <QPainter>

class TrackViewPrivate
{
public:
    ColumbusModel *model;

    qreal zoom;
    qreal rotation;
    QPointF position;
};

TrackView::TrackView(QWidget *parent) : QWidget(parent)
{
    this->d = new TrackViewPrivate;

    d->model = NULL;
    d->zoom  = 20.0f;
    d->rotation = 0.0f;
    d->position = QPointF(0.0f, 0.0f);
}

TrackView::~TrackView()
{
    delete this->d;
}

ColumbusModel* TrackView::model()
{
    return d->model;
}

void TrackView::setModel(ColumbusModel *model)
{
    d->model = model;
    this->update();
    emit this->modelUpdated(d->model);
}

qreal TrackView::zoom() const
{
    return d->zoom;
}

void TrackView::setZoom(qreal zoom)
{
    d->zoom = zoom;
    this->update();
    emit this->zoomUpdated(d->zoom);
}

qreal TrackView::rotation() const
{
    return d->rotation;
}

void TrackView::setRotation(double rotation)
{
    d->rotation = rotation;
    this->update();
    emit this->rotationUpdated((qreal)rotation);
}

QPointF TrackView::position() const
{
    return d->position;
}

void TrackView::setPosition(QPointF position)
{
    d->position = position;
    this->update();
    emit this->positionUpdated(d->position);
}

void TrackView::paintEvent(QPaintEvent*)
{
    const int width     = this->width();
    const int height    = this->height();

    if(d->model == NULL || d->model->tracklog()->count() == 0) return;

    qreal lat   = d->model->tracklog()->last().latitude();
    qreal lon   = d->model->tracklog()->last().longitude();

    qreal dim   = 1000 * d->zoom;

    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);

    painter.setViewport(0, 0, width, height);
    painter.setWindow(-(width / 2), -(height / 2), width, height); // To make center (0, 0) units.

    painter.setPen(QPen(this->palette().foreground(), 1.0f));
    painter.setBrush(QBrush(this->palette().foreground()));

    painter.drawPoint(0, 0);

    painter.setMatrix(QMatrix());
    painter.rotate(-d->rotation);

    int px = 0;
    int py = 0;

    for(int i = d->model->tracklog()->count() - 1; i > 0 ; i--)
    {
        qreal rLat = d->model->tracklog()->value(i).latitude();
        qreal rLon = d->model->tracklog()->value(i).longitude();

        int x = (lon - rLon) * dim;
        int y = (lat - rLat) * dim;

        painter.drawLine(-px, py, -x, y);

        px = x; py = y;
    }
}
