#include "AltitudeProfileGraph.h"

#include <QDebug>
#include <QtGui>

class AltitudeProfileGraphPrivate
{
public:
    ColumbusModel *model;
};

AltitudeProfileGraph::AltitudeProfileGraph(QWidget *parent)
    : AbstractChart(parent)
{
    this->d = new AltitudeProfileGraphPrivate;
    d->model = NULL;

    QSizePolicy policy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    policy.setHeightForWidth(true);
    this->setSizePolicy(policy);

    this->setLabel(tr("Elevation Profile"));
}

ColumbusModel* AltitudeProfileGraph::model() const
{
    return d->model;
}

void AltitudeProfileGraph::setColumbusModel(ColumbusModel *model)
{
    d->model = model;
}

void AltitudeProfileGraph::paintEvent(QPaintEvent*)
{
    const int width = this->width();
    int height = this->height();

    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing, true);

    painter.setPen(QPen(QColor(0xff, 0xff, 0xff), 1.0f));
    painter.setFont(QFont(painter.font().family(), 10));
    QRect rect = painter.boundingRect(0, 0, 0, 0, 0, this->label());
    painter.drawText(width / 2 - (rect.width() / 2), height - rect.height(),
                     rect.width(), rect.height(),
                     0,
                     this->label());

    height = height - rect.height() - 2;

    painter.setViewport(0, 0, width, height);
    painter.setWindow(0, 0, width, height);

    QColor sColor = this->palette().foreground().color();
    painter.setPen(QPen(sColor, 0.5f));

    int m = 12;
    for(int i = 1; i < m; i++)
    {
        painter.drawLine(0, (height / m) * i + height % m, width, (height / m) * i  + height % m);
    }

    painter.setPen(QPen(this->palette().foreground().color(), 1.0f));
    painter.drawLine(0, height + 1, width, height + 1);

    if(d->model != NULL && d->model->tracklog()->count() > 0)
    {
        const qreal max = d->model->maximumAltitude();
        const qreal min = d->model->minimumAltitude();
        const qreal scale = qMax((max - min), (qreal)100.0f) / (height * 0.9f); // We add padding to the height here.

        const int rCount = d->model->tracklog()->count();

        qreal pAltitude = d->model->tracklog()->last().altitude();

        for(int i = qMin(rCount, width); i > 0; i--)
        {
            QGeoCoordinate coord = d->model->tracklog()->value(rCount - 1 - i);

            if(coord.type() != QGeoCoordinate::Coordinate3D) continue;

            qreal altitude = coord.altitude();

            painter.drawLine(width - i, height - (altitude * scale),
                             width - i - 1, height - (pAltitude * scale));

            pAltitude = altitude;
        }
    }
}
