#ifndef MAEMO5DIALOG_H
#define MAEMO5DIALOG_H

#include <QDialog>
#include "ApplicationController.h"

class Maemo5Dialog : public QDialog
{
    Q_OBJECT
    Q_PROPERTY(ApplicationController *controller READ controller WRITE setController)

public:
    explicit Maemo5Dialog (QWidget *parent = 0) : QDialog(parent) {/* DO NOTHING */}

    ApplicationController* controller() const { return m_Controller; }

public slots:
    virtual void setController(ApplicationController *controller)
    {
        m_Controller = controller;
    }

    void show ()
    {
        this->setAttribute(Qt::WA_Maemo5PortraitOrientation,
                           this->parentWidget()->width() < this->parentWidget()->height());
        QDialog::show();
    }

private:
    ApplicationController *m_Controller;
};

#endif // MAEMO5DIALOG_H
