#include "ColumbusDialogWaypoints.h"

#include <QtGui>
#include <QtMaemo5>

class ColumbusDialogWaypointsPrivate
{
public:
    ApplicationController *controller;

    QScrollArea *scrollarea;
};

ColumbusDialogWaypoints::ColumbusDialogWaypoints(QWidget *parent)
    : Maemo5Dialog(parent)
{
    new QVBoxLayout(this);
    this->d = new ColumbusDialogWaypointsPrivate;
}

ColumbusDialogWaypoints::~ColumbusDialogWaypoints()
{
    delete this->d;
}

void ColumbusDialogWaypoints::setController(ApplicationController *controller)
{
    d->controller = controller;

    if(this->layout()->isEmpty())
    {
        this->setupUi();
        this->updateUi();
    }
}

void ColumbusDialogWaypoints::setupUi()
{
    d->scrollarea = new QScrollArea(this);
    d->scrollarea->setWidgetResizable(true);
    d->scrollarea->setWidget(new QWidget(this));

    QVBoxLayout *vbox = new QVBoxLayout(d->scrollarea->widget());

    vbox->addWidget(new QPushButton(tr("Browse Waypoints")));
    vbox->addWidget(new QPushButton(tr("Create Waypoint")));
    vbox->addWidget(new QPushButton(tr("Import")));
    vbox->addWidget(new QPushButton(tr("Export")));

    this->layout()->addWidget(d->scrollarea);
    this->setWindowTitle(tr("Waypoints"));
}

void ColumbusDialogWaypoints::updateUi()
{

}
