#ifndef LOGGINGMANAGER_H
#define LOGGINGMANAGER_H

#include <QHash>
#include <QObject>

#include "data/AbstractDataFormatter.h"
#include "data/AbstractDataLogger.h"

class ApplicationController;
class LoggingManagerPrivate;

class LoggingManager : public QObject
{
    Q_OBJECT

public:
    explicit LoggingManager(QObject *parent = 0);
            ~LoggingManager();

    QHash<QString,AbstractDataFormatter*>                formatters () const;
    QHash<AbstractDataLogger*,AbstractDataFormatter*>    loggers    () const;

public slots:
    void     initialize     (ApplicationController *controller);
    void     setupLogging   ();

    void     addDataFormat  (AbstractDataFormatter *formatter);

    void     addLogger      (AbstractDataFormatter *formatter, AbstractDataLogger *logger);
    void     removeLogger   (AbstractDataLogger *logger);

private:
    LoggingManagerPrivate *d;
};

#endif // LOGGINGMANAGER_H
