#include "UDPNetworkConnector.h"

#include <QUdpSocket>

class UDPNetworkConnectorPrivate
{
public:
    QHostAddress address;
    quint16 port;

    QAbstractSocket *socket;
    ServicePerformer *performer;
    ServicePerformerFactory *factory;
};

UDPNetworkConnector::UDPNetworkConnector(const QHostAddress &address, quint16 port, ServicePerformerFactory *factory, QObject *parent)
    : NetworkServiceProvider(parent)
{
    this->d = new UDPNetworkConnectorPrivate;
    d->address = address;
    d->port = port;
    d->factory = factory;
    d->performer = NULL;
}

UDPNetworkConnector::~UDPNetworkConnector()
{
    if(d->performer != NULL)
    {
        d->factory->destroyInstance(d->performer);
        d->performer = NULL;
    }

    d->socket->close();
    delete this->d;

    emit this->statusChanged("Disabled");
}

bool UDPNetworkConnector::initialize()
{
    d->socket = new QUdpSocket(this);
    QObject::connect(d->socket, SIGNAL(connected()), this, SLOT(onConnect()));
    d->socket->connectToHost(d->address, d->port, QUdpSocket::WriteOnly);
    return true;
}

void UDPNetworkConnector::onConnect()
{
    qDebug() << "UDPNetworkConnector - Connected to remote"
             << QString("%1:%2").arg(d->socket->peerAddress().toString(), QString::number(d->socket->peerPort()));
    qDebug() << "UDPNetworkConnector - Creating service performer.";
    d->performer = d->factory->createInstance(d->socket, this);

    emit this->statusChanged(QString("UDP streaming to %1:%2").arg(d->socket->peerAddress().toString(), QString::number(d->socket->peerPort())));
}
