#include "ServicePerformerFactory.h"

#include <QDebug>

class ServicePerformerFactoryPrivate
{
public:
    LoggingManager          *manager;
    AbstractDataFormatter   *formatter;
};

ServicePerformerFactory::ServicePerformerFactory(AbstractDataFormatter *formatter, LoggingManager *manager, QObject *parent)
    : QObject(parent)
{
    this->d = new ServicePerformerFactoryPrivate;
    d->manager = manager;
    d->formatter = formatter;
}

ServicePerformer* ServicePerformerFactory::createInstance(QIODevice *io, QObject *parent)
{
    qDebug() << "ServicePerformerFactory - Creating instance.";
    ServicePerformer *result = new ServicePerformer(io, parent);
    qDebug() << "ServicePerformerFactory - Registering instance with logging manager.";
    d->manager->addLogger(d->formatter, result);
    return result;
}

void ServicePerformerFactory::destroyInstance(ServicePerformer *performer)
{
    qDebug() << "ServicePerformerFactory: destroyInstance() - Unregistering with logging manager.";
    d->manager->removeLogger(performer);
    delete performer;
}
