#! /bin/sh

for image in $(ls images); do
  size=$(identify "images/$image" | awk '{print $3}')

  if [ "$size" = "800x480" ]; then
    orientation=landscape
    scale=400x240
  else
    orientation=portrait
    scale=120x240
  fi

  # Add corners using our mask.
  convert images/$image null: resources/$orientation-image-mask.png \
    -compose CopyOpacity -layers composite -trim +repage /var/tmp/processed-image-tmp.png

  # Paint on top of shadow image.
  composite -gravity center /var/tmp/processed-image-tmp.png resources/$orientation-drop-shadow.png "processed/$image"

  convert "processed/$image" -resize "${scale}" "scaled/$image"

  rm /var/tmp/processed-image-tmp.png
done

