TARGET = columbus

QT = core gui dbus maemo5

INCLUDEPATH += ./src

LIBS += -lbluetooth

# If your application uses the Qt Mobility libraries, uncomment
# the following lines and add the respective components to the 
# MOBILITY variable. 
CONFIG += mobility
MOBILITY += systeminfo location

HEADERS += \
    src/config.h \
    src/ApplicationController.h \
    src/LoggingManager.h \
    src/ConfigManager.h \
    src/PluginManager.h \
    src/ColumbusPlugin.h \
    src/data/FileDataLoggerConfig.h \
    src/data/TripModel.h \
    src/data/units.h \
    src/data/NMEADataFormatter.h \
    src/data/AbstractDataLogger.h \
    src/data/AbstractDataFormatter.h \
    src/data/FileDataLogger.h \
    src/ui/widgets/DraggableViewArea.h \
    src/ui/widgets/CompassSlide.h \
    src/ui/widgets/CompassPrivate.h \
    src/ui/widgets/CompassDial.h \
    src/ui/widgets/AbstractCompass.h \
    src/ui/widgets/Maemo5MenuButton.h \
    src/ui/widgets/Maemo5TaskButton.h \
    src/ui/widgets/Maemo5Dialog.h \
    src/ui/widgets/SignalGraph.h \
    src/ui/widgets/AccuracyGraph.h \
    src/ui/widgets/SatelliteCompassDial.h \
    src/ui/widgets/LCDIndicator.h \
    src/ui/widgets/TrackView.h \
    src/ui/widgets/SpeedGraph.h \
    src/ui/widgets/AltitudeProfileGraph.h \
    src/ui/widgets/AbstractChart.h \
    src/ui/MainWindow.h \
    src/ui/ApplicationView.h \
    src/ui/ApplicationViewSwitcher.h \
    src/ui/ColumbusStatisticsView.h \
    src/ui/ColumbusStatusView.h \
    src/ui/ColumbusTrackView.h \
    src/ui/ColumbusDialogLogging.h \
    src/ui/ColumbusDialogOptions.h \
    src/ui/ColumbusDialogTools.h \
    src/ui/ColumbusDialogWaypoints.h \
    plugins/bluetooth-server/BluetoothServerPlugin.h \
    plugins/network-server/NetworkServerPlugin.h \
    plugins/bluetooth-server/BluetoothOptionsDialog.h \
    plugins/bluetooth-server/BluetoothSocket.h \
    plugins/network-server/NetworkOptionsDialog.h \
    plugins/generic-server/ServicePerformer.h \
    plugins/generic-server/ServicePerformerFactory.h \
    plugins/bluetooth-server/BluetoothAcceptor.h \
    plugins/network-server/TCPNetworkConnector.h \
    plugins/network-server/TCPNetworkAcceptor.h \
    plugins/network-server/UDPNetworkConnector.h \
    plugins/network-server/NetworkServiceProvider.h \
    plugins/bluetooth-server/BluetoothConnector.h \
    plugins/bluetooth-server/BluetoothServiceProvider.h \
    plugins/bluetooth-server/BluetoothServerConfig.h \
    plugins/network-server/NetworkServerConfig.h \
    plugins/usb-serial/USBSerialPlugin.h \
    plugins/usb-serial/USBSerialOptionsDialog.h \
    plugins/usb-serial/USBSerialConfig.h \
    plugins/usb-serial/SerialPort.h

SOURCES += \
    src/main.cpp \
    src/ApplicationController.cpp \
    src/LoggingManager.cpp \
    src/ConfigManager.cpp \
    src/PluginManager.cpp \
    src/data/NMEADataFormatter.cpp \
    src/data/FileDataLogger.cpp \
    src/data/FileDataLoggerConfig.cpp \
    src/data/TripModel.cpp \
    src/ui/widgets/DraggableViewArea.cpp \
    src/ui/widgets/CompassSlide.cpp \
    src/ui/widgets/CompassDial.cpp \
    src/ui/widgets/AbstractCompass.cpp \
    src/ui/widgets/SignalGraph.cpp \
    src/ui/widgets/AccuracyGraph.cpp \
    src/ui/widgets/SatelliteCompassDial.cpp \
    src/ui/widgets/LCDIndicator.cpp \
    src/ui/widgets/TrackView.cpp \
    src/ui/widgets/SpeedGraph.cpp \
    src/ui/widgets/AltitudeProfileGraph.cpp \
    src/ui/widgets/AbstractChart.cpp \
    src/ui/MainWindow.cpp \
    src/ui/ApplicationView.cpp \
    src/ui/ApplicationViewSwitcher.cpp \
    src/ui/ColumbusDialogWaypoints.cpp \
    src/ui/ColumbusStatisticsView.cpp \
    src/ui/ColumbusStatusView.cpp \
    src/ui/ColumbusTrackView.cpp \
    src/ui/ColumbusDialogLogging.cpp \
    src/ui/ColumbusDialogOptions.cpp \
    src/ui/ColumbusDialogTools.cpp \
    plugins/bluetooth-server/BluetoothServerPlugin.cpp \
    plugins/bluetooth-server/BluetoothOptionsDialog.cpp \
    plugins/bluetooth-server/BluetoothSocket.cpp \
    plugins/network-server/NetworkOptionsDialog.cpp \
    plugins/network-server/NetworkServerPlugin.cpp \
    plugins/generic-server/ServicePerformer.cpp \
    plugins/generic-server/ServicePerformerFactory.cpp \
    plugins/bluetooth-server/BluetoothAcceptor.cpp \
    plugins/network-server/TCPNetworkConnector.cpp \
    plugins/network-server/TCPNetworkAcceptor.cpp \
    plugins/network-server/UDPNetworkConnector.cpp \
    plugins/network-server/NetworkServiceProvider.cpp \
    plugins/bluetooth-server/BluetoothConnector.cpp \
    plugins/bluetooth-server/BluetoothServiceProvider.cpp \
    plugins/bluetooth-server/BluetoothServerConfig.cpp \
    plugins/network-server/NetworkServerConfig.cpp \
    plugins/usb-serial/USBSerialPlugin.cpp \
    plugins/usb-serial/USBSerialOptionsDialog.cpp \
    plugins/usb-serial/USBSerialConfig.cpp \
    plugins/usb-serial/SerialPort.cpp

RESOURCES += \
    resources.qrc

OTHER_FILES += \
    columbus.sudoers \
    columbus.png \
    columbus.desktop

maemo5 {
    target.path = /opt/usr/bin

    desktopicon.files = columbus.png
    desktopicon.path = /usr/share/icons/hicolor/64x64/apps

    desktopfile.files = columbus.desktop
    desktopfile.path = /usr/share/applications/hildon

    sudoersfile.files = columbus.sudoers
    sudoersfile.path = /etc/sudoers.d

    INSTALLS = target desktopicon desktopfile sudoersfile
}
