/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */
char* read_file_contents(char *filename, gsize* lenght) {
    FILE *file;
    char *buffer;

    file = fopen(filename, "rb");
    if (!file) {
        fprintf(stderr, "Unable to open file %s\n", filename);
        return NULL;
    }

    fseek(file, 0, SEEK_END);
    *lenght = ftell(file);
    fseek(file, 0, SEEK_SET);

    //Allocate memory
    buffer = (char *) malloc(*lenght);
    if (!buffer) {
        fprintf(stderr, "Memory allocation error in read_file_contents('%s')\n", filename);
        fclose(file);
        return NULL;
    }

    fread(buffer, *lenght, 1, file);
    fclose(file);
    return buffer;
}
