#!/bin/sh

# defaults
DRIVERPATH="/opt/packet-injection-modules/$1/" 
FILEPATH="/home/user/.cleven"

# Check if needed files exist
if [ -f $DRIVERPATH/compat.ko ] &&
   [ -f $DRIVERPATH/rfkill_backport.ko ] &&
   [ -f $DRIVERPATH/cfg80211.ko ] &&
   [ -f $DRIVERPATH/mac80211.ko ] &&
   [ -f $DRIVERPATH/wl1251.ko ] &&
   [ -f $DRIVERPATH/wl1251_spi.ko ]; then 
    echo "INFO: Driver files found.."
else 
    echo "ERROR: Some or all driver files are missing. Interrupting this action."
    exit
fi

# Read MAC address (and store it if it's the first time) 
MACADDR="`ifconfig wlan0 | sed -n 's/.*HWaddr \([0-9A-Fa-f:]\+\).*/\1/p'`"

if [ ! -f $FILEPATH/myMAC ]; then
   echo $MACADDR > $FILEPATH/myMAC
fi

# Unload wifi modules
rmmod wl1251_spi 2>/dev/null
rmmod wl1251 2>/dev/null
rmmod wl12xx 2>/dev/null
rmmod mac80211 2>/dev/null
rmmod cfg80211 2>/dev/null
rmmod rfkill_backport 2>/dev/null
rmmod compat_firmware_class 2>/dev/null
rmmod compat 2>/dev/null

# Load bleeding-edge wl1251
insmod $DRIVERPATH/compat.ko
insmod $DRIVERPATH/rfkill_backport.ko
insmod $DRIVERPATH/cfg80211.ko
insmod $DRIVERPATH/mac80211.ko
insmod $DRIVERPATH/wl1251.ko
insmod $DRIVERPATH/wl1251_spi.ko
   
# Restore mac address
ifconfig wlan0 down hw ether "$MACADDR"

echo "INFO: Custom wl1251 module loaded (with injection) :)"