#!/bin/sh

killappman () {
killall hildon-application-manager > \/tmp\/output.txt 2> \/dev\/null
killall apt-worker > \/tmp\/output.txt 2> \/dev\/null
killall apt-worker.real > \/tmp\/output.txt 2> \/dev\/null
}


clean () { 
apt-get clean | zenity --progress --pulsate --title="Clean" --text="Wait for the loading bar"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Clean executed"
}

autoclean () { 
apt-get autoclean | zenity --progress --pulsate --title="Autoclean" --text="Wait for the loading bar"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoclean executed"
}

autoremove () {
apt-get autoremove | zenity --progress --pulsate --title="Autoremove" --text="Wait for the loading bar"
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Autoremove executed"
}

purge () {
apt-get purge | zenity --title="Output Purge" --text-info
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
		org.freedesktop.Notifications.SystemNoteInfoprint string:"Purge executed"
}

connessione () {
dbus-send --system --type=method_call --dest=com.nokia.icd_ui /com/nokia/icd_ui com.nokia.icd_ui.show_conn_dlg boolean:false
	sleep 9
		dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Connection in progress... Please wait..."
}

update () {
apt-get update | zenity --title="Output Update" --text-info
	dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Update Completed" 
}

popup_ann () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Abort!"
}

aggiornamenti () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Updates executed"
}

noaggiornamenti () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Abort!"
}

riavvio () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications \
	org.freedesktop.Notifications.SystemNoteInfoprint string:"Restarting... Please wait..."
		reboot
}

backupcreato () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Backup created!"
}

opincorso () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Working... Please wait..."
}

ripristino () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Recovery made"
}

paccinst () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Installed Package"
}

paccdis () {
dbus-send --type=method_call --dest=org.freedesktop.Notifications /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint string:"Uninstalled Package"
}

applicazioni () {
zenity --title=CleanN900 --height 250 --list  --text "Select the operations you are interested" --column "Options" "Create backup of your applications" "Restore from backup applications" "Install a package .deb" "Remove specific package" "Reboot"
}

gestoreaperto () {
zenity --warning --title CleaN900 --text "Do you have application manager open! Press Ok to close, otherwise press out"
}

primostep () {
zenity --title=CleanN900 --height 350 --list  --text "Select the operations you are interested" --column "Options" "clean" "autoclean" "autoremove" "purge" "Update" "Upgrade" "Applications" "Reboot"
}

ricconn () {
zenity --warning --title CleaN900 --text "You must have the active connection, preferably wifi. If you want to connect click OK, otherwise press out"
}

selbackup () {
zenity --title CleaN900 --file-selection --text='Select the file' --filename=/home/user/MyDocs/clean900/ --file-filter "*.txt"
}

seldeb () {
zenity --title CleaN900 --file-selection --text='Select .deb' --filename=/home/user/MyDocs/ --file-filter "*.deb"
}

rempac () {
zenity --entry --title='Uninstall' --text='Enter the name of the package'
}

waitdis () {
zenity --progress --pulsate --title="Uninstall" --text="Wait for the loading bar"
}
