#ifndef LENSCONFIGURATION_H
#define LENSCONFIGURATION_H

#include <QDialog>
#include "ClassicPrint.h"

namespace Ui {
    class LensConfiguration;
}

class LensConfiguration : public QDialog
{
    Q_OBJECT

public:
    explicit LensConfiguration(ClassicPrint* cp, QWidget *parent = 0);
    ~LensConfiguration();

protected:
    void changeEvent(QEvent *e);

private:
    void setCustom();

private:
    Ui::LensConfiguration *ui;

    ClassicPrint*   m_cp;
    bool            m_updating;

	ClassicPrintLens* m_lens;

private slots:
	void on_buttonBox_accepted();
	void on_btn_save_clicked();
    void on_btn_delete_clicked();
    void on_combo_name_activated(QString );
    void on_check_defocus_clicked(bool checked);
    void on_slider_dodge_valueChanged(int value);
    void on_slider_darkness_valueChanged(int value);
    void on_slider_radius_valueChanged(int value);
};

#endif // LENSCONFIGURATION_H
