/*!
** @file	settings.cpp
** 
** @brief	Paths and other settings
**  
*/  
 
/*--------------------------------------------------------------------------- 
** Includes 
*/
#include "ClassicPrintSettings.h"

/*--------------------------------------------------------------------------- 
** Defines and Macros 
*/

/*--------------------------------------------------------------------------- 
** Typedefs 
*/ 
 
/*--------------------------------------------------------------------------- 
** Local function prototypes 
*/ 
 
/*--------------------------------------------------------------------------- 
** Data 
*/
QString     ClassicPrintSettings::m_config_dir;
QString     ClassicPrintSettings::m_noise_dir;
QString     ClassicPrintSettings::m_colour_profile_dir;
QString     ClassicPrintSettings::m_light_bleed_dir;
QString     ClassicPrintSettings::m_frame_dir;
bool		ClassicPrintSettings::m_app_terminating = false;

void ClassicPrintSettings::init(QString app_dir) {
    m_config_dir = app_dir + "/config";
    m_noise_dir = m_config_dir + "/noise";
    m_colour_profile_dir = m_config_dir + "/colour_profile";
    m_light_bleed_dir = m_config_dir + "/light_bleed";
    m_frame_dir = m_config_dir + "/frame";
}

QString ClassicPrintSettings::config_dir() {
    return m_config_dir;
}

QString ClassicPrintSettings::noise_dir() {
    return m_noise_dir;
}

QString ClassicPrintSettings::colour_profile_dir() {
    return m_colour_profile_dir;
}

QString ClassicPrintSettings::light_bleed_dir() {
    return m_light_bleed_dir;
}

QString ClassicPrintSettings::frame_dir() {
    return m_frame_dir;
}

