#include <QtGui/QApplication>
#include <QProcess>
#include "mainwindow.h"
#include "ClassicPrintSettings.h"

int main(int argc, char *argv[])
{
	// This flag ensures that each widget is drawn in it's own native
	// window. This is requried for the video overlay to work correctly
	QCoreApplication::setAttribute(Qt::AA_NativeWindows, true);

	// Initialise the configuration directory
	ClassicPrintSettings::init("/opt/classiccam");

	QApplication a(argc, argv);
	MainWindow w;
#if defined(Q_WS_S60)
    w.showMaximized();
#else
	w.showFullScreen();
	//w.show();
#endif
	// Disable the default camera application otherwise it will
	// automatically start as soon as the lens cover is opened
	// or the shutter is pressed
	QProcess process;
	process.execute("/usr/sbin/dsmetool -k /usr/bin/camera-ui");

	int result = a.exec();

	// Restart the original camera application
	process.execute("/usr/sbin/dsmetool -t /usr/bin/camera-ui");

	return result;
}
