#ifndef FILMCONFIGURATION_H
#define FILMCONFIGURATION_H

#include <QDialog>
#include "ClassicPrint.h"

namespace Ui {
    class FilmConfiguration;
}

class FilmConfiguration : public QDialog
{
    Q_OBJECT

public:
    explicit FilmConfiguration(ClassicPrint* cp, QWidget *parent = 0);
    ~FilmConfiguration();

protected:
    void changeEvent(QEvent *e);

private:
    void setCustom();

private:
    Ui::FilmConfiguration *ui;

    ClassicPrint*   m_cp;
    bool            m_updating;
	ClassicPrintFilm* m_film;

private slots:
	void on_buttonBox_accepted();
	void on_slider_noise_valueChanged(int value);
    void on_slider_temperature_valueChanged(int value);
    void on_btn_delete_clicked();
    void on_btn_save_clicked();
    void on_combo_name_activated(QString );
};

#endif // FILMCONFIGURATION_H
