/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

errordomain ParserError {
	STRING_ERROR,
	EOF
}

class GoogleImageSearchParser : Object {
	char* current;

	public void skip_string () throws Error {
		if (current[0] == 0) {
			throw new ParserError.EOF ("Buffer ends before end of string");
		}
		if (current[0] != '"') {
			throw new ParserError.STRING_ERROR ("String should start with '\"'");
		}
		current++;
		int i = -1;
		while (current[++i] != '"' && current[i] != 0);
		if (current[i] == 0) {
			throw new ParserError.EOF ("Buffer ends before end of string");
		}
		current += i + 1;
		if (current[0] == ',') {
			current++;
		}
	}

	public string? parse_string () throws Error {
		if (current[0] == 0) {
			throw new ParserError.EOF ("Buffer ends before end of string");
		}
		if (current[0] != '"') {
			throw new ParserError.STRING_ERROR ("String should start with '\"'");
		}
		current++;
		int i = -1;
		while (current[++i] != '"' && current[i] != 0);
		if (current[i] == 0) {
			throw new ParserError.EOF ("Buffer ends before end of string");
		}
		string s = ((string) current).ndup (i);
		current += i + 1;
		if (current[0] == ',') {
			current++;
		}
		return s;
	}

	private string? parse_result (bool thumbnail) throws Error {
		current++; // skip [
		if (current[0] == 0)
			return null;
		int i = -1;
		while (current[++i] != ']' && current[i] != 0);
		if (current[i] == 0) {
			throw new ParserError.EOF ("Buffer ends before end of result");
		}
		skip_string (); // "/imgres?imgurl\x3dhttp..."
		skip_string (); // ""
		var code = parse_string ();
		var uri = parse_string ();
		skip_string (); // small width
		skip_string (); // small height 
		skip_string (); // caption
		skip_string (); // ""
		skip_string (); // ""
		skip_string (); // "width x height - size"
		skip_string (); // "jpg"
		skip_string (); // "domain.com"
		skip_string (); // ""
		skip_string (); // ""
		var static_uri = parse_string (); // "http://t?.gstatic.com/images"
		skip_string (); // "1"

		if (thumbnail) {
			return static_uri + "?q=tbn:" + code + uri;
		} else {
			return uri;
		}
	}

	public GoogleImageSearchParser (string buf) {
		current = buf;
	}

	public string? run (bool thumbnail) throws Error {
		current = ((string) current).str ("dyn.setResults([[");
		if (current != null) {
			current += 16;
			return parse_result (thumbnail);
		}
		return null;
	}
}
