/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Hildon;

class IMDbDownloadDialog : Note {
	public IMDbDownloadDialog (Gtk.Window window) {
		transient_parent = window;
	}

	construct {
		note_type = NoteType.PROGRESSBAR;
		progressbar = new ProgressBar ();
	}

	public new void run (dynamic DBus.Object server, string mirror) {
		int res;
		try {
			server.Progress += this.on_progress;
			server.DescriptionChanged += this.on_description_changed;

			server.download (mirror, IMDbDownloader.MOVIES | IMDbDownloader.GENRES | IMDbDownloader.RATINGS);
		} catch (DBus.Error e) {
			warning ("Failed to invoke IMDb downloader: %s", e.message);
		}

		show_all ();

		res = base.run ();
		if (res == ResponseType.CANCEL)
			server.cancel ();
	}

	private void on_progress (dynamic DBus.Object server, int percent) {
		if (percent < 100) {
			progressbar.set_fraction (0.01 * percent);
		} else {
			close ();
		}
	}

	private void on_description_changed (dynamic DBus.Object server, string _description) {
		description = _description;
	}
}
