/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

public abstract class Plugin : Object {
	public abstract void hello (Gtk.Window window, Osso.Context context);

	public abstract unowned List<MovieSource> get_sources ();
	public abstract List<MovieAction> get_actions (Movie movie, Gtk.Window window);

	public abstract void settings_dialog (Gtk.Window window);

	public abstract unowned string get_name ();
}

public abstract class MovieSource : Object {
	public delegate void ReceiveMovieFunction (Movie movie);

	public abstract async void get_movies (MovieFilter filter, ReceiveMovieFunction callback, int limit, GLib.Cancellable? cancellable);

	public abstract void add_movie (Movie movie);
	public abstract void delete_movie (Movie movie);

	public abstract unowned string get_name ();

	public abstract unowned string get_description ();

	public abstract bool get_editable ();
}

public class MovieAction : Object {
	public delegate void MovieActionFunc (Movie movie, Gtk.Window window);

	public string name;
	private MovieActionFunc action;
	private Movie movie;
	private Gtk.Window window;

	public MovieAction (string _name, MovieActionFunc _action, Movie _movie, Gtk.Window _window) {
		name = _name;
		action = _action;
		movie = _movie;
		window = _window;
	}

	public void execute () {
		action (movie, window);
	}
}
