/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Hildon;
using Osso;

public class MovieMenu : AppMenu {
	private Movie movie;
	private MovieListStore store;
	private Gtk.Window parent_window;
	private List<MovieAction> actions;

	public MovieMenu (Movie _movie, MovieListStore _store, Gtk.Window window) {
		movie = _movie;
		store = _store;
		parent_window = window;
		foreach (Plugin plugin in CinaestProgram.plugins) {
			foreach (MovieAction action in plugin.get_actions (movie, window)) {
				var button = new Gtk.Button.with_label (action.name);
				button.clicked.connect (action.execute);
				append (button);
				actions.append (action);
			}
		}
		if (store.get_editable ()) {
			var button = new Gtk.Button.with_label (_("Delete movie"));
			button.clicked.connect (on_delete_movie);
			append (button);
		}

		show_all ();
	}

	private void on_delete_movie () {
		var dialog = new Note.confirmation (parent_window, _("Delete movie '%s'?").printf (movie.title));
		var res = dialog.run ();

		if (res == Gtk.ResponseType.OK) {
			store.remove (movie);
		}
		dialog.destroy ();
	}
}

