/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

public enum GenreType {
	ANIMATION = 0,
	ADULT,
	DRAMA,
	SHORT,
	ACTION,
	FANTASY,
	HORROR,
	SCIFI,
	THRILLER,
	BIOGRAPHY,
	COMEDY,
	MUSICAL,
	ADVENTURE,
	DOCUMENTARY,
	CRIME,
	MUSIC,
	SPORT,
	ROMANCE,
	HISTORY,
	MYSTERY,
	WAR,
	WESTERN,
	FAMILY,
	TALKSHOW,
	REALITYTV,
	GAMESHOW,
	NEWS,
	FILMNOIR
}

public struct Genres {
	private static const string[] _genre_string = {
		"Animation",
		"Adult",
		"Drama",
		"Short",
		"Action",
		"Fantasy",
		"Horror",
		"Sci-Fi",
		"Thriller",
		"Biography",
		"Comedy",
		"Musical",
		"Adventure",
		"Documentary",
		"Crime",
		"Music",
		"Sport",
		"Romance",
		"History",
		"Mystery",
		"War",
		"Western",
		"Family",
		"Talk-Show",
		"Reality-TV",
		"Game-Show",
		"News",
		"Film-Noir"
	};

	public int field;

	public string to_string () {
		string s = null;

		for (int i = 0; i < 28; i++) {
			if ((1 << i) in field) {
				if (s == null) {
					s = _genre_string[i];
				} else {
					s += ", " + _genre_string[i];
				}
			}
		}

		return s;
	}

	public void set_bit (GenreType genre, bool enable) {
		if (enable)
			field |= (1 << genre);
		else
			field &= ~(1 << genre);
	}

	public bool get_bit (GenreType genre) {
		return (genre in field);
	}

	public static unowned string genre_string (GenreType genre) {
		return _genre_string[genre];
	}

/*
	public static int genre_bit (string genre) {
		int i = 0;

		do {
			if (_genres[i] == genre) {
				return (1 << i);
			}
		} while (++i < 28);

		return 0;
	}
*/
}

