/* This file is part of Cinaest.
 *
 * Copyright (C) 2009 Philipp Zabel
 *
 * Cinaest is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Cinaest is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cinaest. If not, see <http://www.gnu.org/licenses/>.
 */

using Hildon;
using Gtk;

class SourceDialog : Gtk.Dialog {
	List<MovieSource> sources;

	public SourceDialog (Gtk.Window window) {
		set_transient_for (window);
		set_title (_("Select movie source"));

		var content = (VBox) get_content_area ();
		content.set_size_request (-1, 5*70);

		sources = new List<MovieSource> ();
		foreach (Plugin plugin in CinaestProgram.plugins) {
			foreach (MovieSource source in plugin.get_sources ()) {
				sources.append (source);
			}
		}

		var source_list = new SourceListView (sources);
		content.pack_start (source_list, true, true, 0);

		source_list.source_activated.connect (on_source_activated);
	}

	public void on_source_activated (MovieSource source) {
		int n = sources.index (source);

		response (n);
	}

	public new int run (ref MovieSource source) {
		int res = 0;

		show_all ();

		res = base.run ();
		destroy ();

		if (res >= 0) {
			source = sources.nth_data (res);
			return 0;
		}

		return res;
	}
}

