#ifndef CHARMAP_H
#define CHARMAP_H

#include <QMainWindow>
#include <QResizeEvent>

#include "ui_charmap.h"

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow();

private:
    void resizeEvent(QResizeEvent *event);
    void addCharButtons(uint columns);
    void removeCharButtons();

private slots:
    void on_actionAbout_triggered();
    void buttonChar_clicked(uint id);
    void buttonCopy_clicked();
    void buttonClear_clicked();

private:
    Ui::MainWindow ui;
    int w;
    QLabel *labelCharacter;
    QLabel *labelUnicode;
    QLabel *labelDescription;
    QLineEdit *edit;
};

#endif // CHARMAP_H
