#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gtk/gtk.h>

#ifdef USE_HILDON
#    include <hildon/hildon-program.h>
#    include <hildon/hildon-number-editor.h>
#endif

#include "callbacks.h"
#include "interface2.h"
#include "interface.h"
#include "support.h"
#include "gtkimageview.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget*
create_MainWindow (void)
{
  GtkWidget *MainWindow;
  GtkWidget *main_scroller;
  GtkWidget *main_canvas;
  gint event_mask;


#ifdef USE_HILDON
  HildonProgram* program;
  program = HILDON_PROGRAM(hildon_program_get_instance());
  MainWindow = hildon_window_new();
  hildon_program_add_window(program, HILDON_WINDOW(MainWindow));
  g_set_application_name(_("cbrPager"));
#else
  MainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request (MainWindow, 400, 500);
  gtk_window_set_title (GTK_WINDOW (MainWindow), _("cbrPager"));
#endif

  main_scroller = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (main_scroller);
  gtk_container_add (GTK_CONTAINER (MainWindow), main_scroller);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (main_scroller), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  main_canvas = gtk_image_view_new();
  gtk_image_view_set_show_frame(GTK_IMAGE_VIEW(main_canvas), FALSE);
#ifdef USE_HILDON
  gtk_image_view_set_interpolation(GTK_IMAGE_VIEW(main_canvas), GDK_INTERP_TILES);
#endif
  
  gtk_widget_show (main_canvas);
  gtk_container_add (GTK_CONTAINER (main_scroller), main_canvas);

  g_signal_connect ((gpointer) MainWindow, "delete_event",
                    G_CALLBACK (on_MainWindow_delete_event),
                    NULL);
  g_signal_connect ((gpointer) MainWindow, "realize",
                    G_CALLBACK (on_MainWindow_realize),
                    NULL);
  g_signal_connect ((gpointer) MainWindow, "size_allocate",
                    G_CALLBACK (on_MainWindow_size_allocate),
                    NULL);
  g_signal_connect ((gpointer) main_canvas, "button_press_event",
                    G_CALLBACK (on_main_canvas_button_press_event),
                    NULL);
  g_signal_connect ((gpointer) main_canvas, "motion_notify_event",
		    G_CALLBACK (on_main_canvas_motion_event),
		    NULL);
  g_signal_connect ((gpointer) main_canvas, "button_release_event",
                    G_CALLBACK (on_main_canvas_button_release_event),
                    NULL);
  /* Work around a Maemo bug */
#if USE_HILDON
  event_mask = gtk_widget_get_events(main_canvas) | GDK_KEY_RELEASE_MASK;
  gtk_widget_set_events(main_canvas, event_mask);
  g_signal_connect ((gpointer) main_canvas, "key_release_event",
		    G_CALLBACK (on_main_canvas_key_release_event),
		    NULL);
#endif
  g_signal_connect ((gpointer) main_canvas, "key_press_event",
                    G_CALLBACK (on_main_canvas_key_press_event),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (MainWindow, MainWindow, "MainWindow");
  GLADE_HOOKUP_OBJECT (MainWindow, main_scroller, "main_scroller");
  GLADE_HOOKUP_OBJECT (MainWindow, main_canvas, "main_canvas");

  return MainWindow;
}

GtkWidget*
create_toolbar(GtkWidget* connect_parent)
{
  GtkWidget* nav_toolbar;
  GtkIconSize tmp_toolbar_icon_size;
  GtkWidget *toolitem1;
  GtkWidget *begin_btn;
  GtkWidget *image10;
  GtkWidget *toolitem2;
  GtkWidget *back_btn;
  GtkWidget *back_img;
  GtkWidget *toolitem3;
  GtkWidget *next_btn;
  GtkWidget *image12;
  GtkWidget *toolitem4;
  GtkWidget *last_btn;
  GtkWidget *image13;
  GtkWidget *toolitem5;
  GtkWidget *zoom_out_btn;
  GtkWidget *image4;
  GtkWidget *toolitem6;
  GtkWidget *zoom_in_btn;
  GtkWidget *image6;
  GtkWidget *toolitem7;
  GtkWidget *zoom_orig_btn;
  GtkWidget *image15;
  GtkWidget *toolitem8;
  GtkWidget *zoom_width_btn;
  GtkWidget *image16;
  GtkWidget *toolitem9;
  GtkWidget *zoom_fit_btn;
  GtkWidget *image5;
  GtkWidget *toolitem10;
  GtkWidget *open_btn;
  GtkWidget *image8;
  GtkWidget *toolitem11;
  GtkWidget *pref_btn;
  GtkWidget *image14;
  GtkWidget *toolitem13;
  GtkWidget *quit_btn;
  GtkWidget *image9;
#if !USE_HILDON
  GtkWidget *toolitem14;
  GtkWidget *file_list_tbtn;
  GtkWidget *image17;
#endif
  GtkWidget *toolitem15;
  GtkWidget *rotate_tbtn;
  GtkWidget *image18;
  GtkWidget *toolitem16;
  GtkWidget *fullscreen_tbtn;
  GtkWidget *image19;
  GtkWidget *toolitem17;
  GtkWidget *toggle_btn;
  GtkWidget *image20;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  nav_toolbar = gtk_toolbar_new ();

  gtk_toolbar_set_style (GTK_TOOLBAR (nav_toolbar), GTK_TOOLBAR_BOTH);
#if USE_HILDON
  gtk_toolbar_set_orientation (GTK_TOOLBAR (nav_toolbar), GTK_ORIENTATION_HORIZONTAL);
#else
  gtk_toolbar_set_orientation (GTK_TOOLBAR (nav_toolbar), GTK_ORIENTATION_VERTICAL);
#endif
  gtk_toolbar_set_show_arrow (GTK_TOOLBAR (nav_toolbar), FALSE);
  tmp_toolbar_icon_size = gtk_toolbar_get_icon_size (GTK_TOOLBAR (nav_toolbar));

  toolitem1 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem1);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem1);

  begin_btn = gtk_button_new ();
  gtk_widget_show (begin_btn);
  gtk_container_add (GTK_CONTAINER (toolitem1), begin_btn);
  gtk_tooltips_set_tip (tooltips, begin_btn, _("To first page"), NULL);
  gtk_button_set_relief (GTK_BUTTON (begin_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(begin_btn, GTK_CAN_FOCUS);

  image10 = gtk_image_new_from_stock ("gtk-goto-first", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image10);
  gtk_container_add (GTK_CONTAINER (begin_btn), image10);

  toolitem2 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem2);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem2);

  back_btn = gtk_button_new ();
  gtk_widget_show (back_btn);
  gtk_container_add (GTK_CONTAINER (toolitem2), back_btn);
  gtk_tooltips_set_tip (tooltips, back_btn, _("Previous page"), NULL);
  gtk_button_set_relief (GTK_BUTTON (back_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(back_btn, GTK_CAN_FOCUS);

  back_img = gtk_image_new_from_stock ("gtk-go-back", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (back_img);
  gtk_container_add (GTK_CONTAINER (back_btn), back_img);

  toolitem3 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem3);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem3);

  next_btn = gtk_button_new ();
  gtk_widget_show (next_btn);
  gtk_container_add (GTK_CONTAINER (toolitem3), next_btn);
  gtk_tooltips_set_tip (tooltips, next_btn, _("Next page"), NULL);
  gtk_button_set_relief (GTK_BUTTON (next_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(next_btn, GTK_CAN_FOCUS);

  image12 = gtk_image_new_from_stock ("gtk-go-forward", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image12);
  gtk_container_add (GTK_CONTAINER (next_btn), image12);

  toolitem4 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem4);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem4);

  last_btn = gtk_button_new ();
  gtk_widget_show (last_btn);
  gtk_container_add (GTK_CONTAINER (toolitem4), last_btn);
  gtk_tooltips_set_tip (tooltips, last_btn, _("To last page"), NULL);
  gtk_button_set_relief (GTK_BUTTON (last_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(last_btn, GTK_CAN_FOCUS);

  image13 = gtk_image_new_from_stock ("gtk-goto-last", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image13);
  gtk_container_add (GTK_CONTAINER (last_btn), image13);

  toolitem5 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem5);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem5);

  zoom_out_btn = gtk_button_new ();
  gtk_widget_show (zoom_out_btn);
  gtk_container_add (GTK_CONTAINER (toolitem5), zoom_out_btn);
  gtk_tooltips_set_tip (tooltips, zoom_out_btn, _("Zoom out (10%)"), NULL);
  gtk_button_set_relief (GTK_BUTTON (zoom_out_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(zoom_out_btn, GTK_CAN_FOCUS);

  image4 = gtk_image_new_from_stock ("gtk-zoom-out", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image4);
  gtk_container_add (GTK_CONTAINER (zoom_out_btn), image4);

  toolitem6 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem6);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem6);

  zoom_in_btn = gtk_button_new ();
  gtk_widget_show (zoom_in_btn);
  gtk_container_add (GTK_CONTAINER (toolitem6), zoom_in_btn);
  gtk_tooltips_set_tip (tooltips, zoom_in_btn, _("Zoom in (10%)"), NULL);
  gtk_button_set_relief (GTK_BUTTON (zoom_in_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(zoom_in_btn, GTK_CAN_FOCUS);

  image6 = gtk_image_new_from_stock ("gtk-zoom-in", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image6);
  gtk_container_add (GTK_CONTAINER (zoom_in_btn), image6);

  toolitem7 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem7);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem7);

  zoom_orig_btn = gtk_button_new ();
  gtk_widget_show (zoom_orig_btn);
  gtk_container_add (GTK_CONTAINER (toolitem7), zoom_orig_btn);
  gtk_tooltips_set_tip (tooltips, zoom_orig_btn, _("Zoom to 1:1"), NULL);
  gtk_button_set_relief (GTK_BUTTON (zoom_orig_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(zoom_orig_btn, GTK_CAN_FOCUS);

  image15 = gtk_image_new_from_stock ("gtk-zoom-100", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image15);
  gtk_container_add (GTK_CONTAINER (zoom_orig_btn), image15);

  toolitem8 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem8);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem8);

  zoom_width_btn = gtk_button_new ();
  gtk_widget_show (zoom_width_btn);
  gtk_container_add (GTK_CONTAINER (toolitem8), zoom_width_btn);
  gtk_tooltips_set_tip (tooltips, zoom_width_btn, _("Zoom to page width"), NULL);
  gtk_button_set_relief (GTK_BUTTON (zoom_width_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(zoom_width_btn, GTK_CAN_FOCUS);

  image16 = gtk_image_new_from_stock ("gtk-justify-fill", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image16);
  gtk_container_add (GTK_CONTAINER (zoom_width_btn), image16);

  toolitem9 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem9);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem9);

  zoom_fit_btn = gtk_button_new ();
  gtk_widget_show (zoom_fit_btn);
  gtk_container_add (GTK_CONTAINER (toolitem9), zoom_fit_btn);
  gtk_tooltips_set_tip (tooltips, zoom_fit_btn, _("Fit image to window"), NULL);
  gtk_button_set_relief (GTK_BUTTON (zoom_fit_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(zoom_fit_btn, GTK_CAN_FOCUS);

  image5 = gtk_image_new_from_stock ("gtk-zoom-fit", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image5);
  gtk_container_add (GTK_CONTAINER (zoom_fit_btn), image5);

  toolitem10 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem10);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem10);

  open_btn = gtk_button_new ();
  gtk_widget_show (open_btn);
  gtk_container_add (GTK_CONTAINER (toolitem10), open_btn);
  gtk_tooltips_set_tip (tooltips, open_btn, _("Open a file..."), NULL);
  gtk_button_set_relief (GTK_BUTTON (open_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(open_btn, GTK_CAN_FOCUS);

  image8 = gtk_image_new_from_stock ("gtk-open", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image8);
  gtk_container_add (GTK_CONTAINER (open_btn), image8);

  toolitem11 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem11);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem11);

  pref_btn = gtk_button_new ();
  gtk_widget_show (pref_btn);
  gtk_container_add (GTK_CONTAINER (toolitem11), pref_btn);
  gtk_tooltips_set_tip (tooltips, pref_btn, _("Preferences"), NULL);
  gtk_button_set_relief (GTK_BUTTON (pref_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(pref_btn, GTK_CAN_FOCUS);

  image14 = gtk_image_new_from_stock ("gtk-preferences", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image14);
  gtk_container_add (GTK_CONTAINER (pref_btn), image14);

  toolitem13 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem13);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem13);

  quit_btn = gtk_button_new ();
  gtk_widget_show (quit_btn);
  gtk_container_add (GTK_CONTAINER (toolitem13), quit_btn);
  gtk_tooltips_set_tip (tooltips, quit_btn, _("Quit"), NULL);
  gtk_button_set_relief (GTK_BUTTON (quit_btn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(quit_btn, GTK_CAN_FOCUS);

  image9 = gtk_image_new_from_stock ("gtk-quit", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image9);
  gtk_container_add (GTK_CONTAINER (quit_btn), image9);

#if !USE_HILDON
  toolitem14 = (GtkWidget*) gtk_tool_item_new ();
  gtk_widget_show (toolitem14);
  gtk_container_add (GTK_CONTAINER (nav_toolbar), toolitem14);

  file_list_tbtn = gtk_button_new ();
  gtk_container_add (GTK_CONTAINER (toolitem14), file_list_tbtn);
  gtk_tooltips_set_tip (tooltips, file_list_tbtn, _("Page list"), NULL);
  gtk_button_set_relief (GTK_BUTTON (file_list_tbtn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(file_list_tbtn, GTK_CAN_FOCUS);

  image17 = gtk_image_new_from_stock ("gtk-sort-ascending", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show (image17);
  gtk_container_add (GTK_CONTAINER (file_list_tbtn), image17);
#endif

  toolitem15 = (GtkWidget*) gtk_tool_item_new();
  gtk_widget_show(toolitem15);
  gtk_container_add(GTK_CONTAINER(nav_toolbar), toolitem15);
  
  rotate_tbtn = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(toolitem15), rotate_tbtn);
  gtk_tooltips_set_tip(tooltips, rotate_tbtn, _("Rotate"), NULL);
  gtk_button_set_relief(GTK_BUTTON(rotate_tbtn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(rotate_tbtn, GTK_CAN_FOCUS);
  
  image18 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show(image18);
  gtk_container_add(GTK_CONTAINER(rotate_tbtn), image18);

  toolitem16 = (GtkWidget*) gtk_tool_item_new();
  gtk_widget_show(toolitem16);
  gtk_container_add(GTK_CONTAINER(nav_toolbar), toolitem16);
  
  fullscreen_tbtn = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(toolitem16), fullscreen_tbtn);
  gtk_tooltips_set_tip(tooltips, fullscreen_tbtn, _("Fullscreen"), NULL);
  gtk_button_set_relief(GTK_BUTTON(fullscreen_tbtn), GTK_RELIEF_NONE);
  GTK_WIDGET_UNSET_FLAGS(fullscreen_tbtn, GTK_CAN_FOCUS);

  image19 = gtk_image_new_from_stock ("gtk-fullscreen", GTK_ICON_SIZE_SMALL_TOOLBAR);
  gtk_widget_show(image19);
  gtk_container_add(GTK_CONTAINER(fullscreen_tbtn), image19);

  g_signal_connect ((gpointer) begin_btn, "clicked",
                    G_CALLBACK (on_begin_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) back_btn, "clicked",
                    G_CALLBACK (on_back_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) next_btn, "clicked",
                    G_CALLBACK (on_next_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) last_btn, "clicked",
                    G_CALLBACK (on_last_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) zoom_out_btn, "clicked",
                    G_CALLBACK (on_zoom_out_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) zoom_in_btn, "clicked",
                    G_CALLBACK (on_zoom_in_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) zoom_orig_btn, "clicked",
                    G_CALLBACK (on_zoom_orig_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) zoom_width_btn, "clicked",
                    G_CALLBACK (on_zoom_width_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) zoom_fit_btn, "clicked",
                    G_CALLBACK (on_zoom_fit_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) open_btn, "clicked",
                    G_CALLBACK (on_open_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) pref_btn, "clicked",
                    G_CALLBACK (on_pref_btn_clicked),
                    NULL);
  g_signal_connect ((gpointer) quit_btn, "clicked",
                    G_CALLBACK (on_quit_btn_clicked),
                    NULL);
#if !USE_HILDON
  g_signal_connect ((gpointer) file_list_tbtn, "clicked",
                    G_CALLBACK (on_file_list_tbtn_clicked),
                    NULL);
#endif
  g_signal_connect ((gpointer) rotate_tbtn, "clicked",
		    G_CALLBACK(on_rotate_btn_clicked),
		    NULL);
  g_signal_connect ((gpointer) fullscreen_tbtn, "clicked",
		    G_CALLBACK(on_fullscreen_btn_clicked),
		    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT (connect_parent, nav_toolbar, "nav_toolbar");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem1, "toolitem1");
  GLADE_HOOKUP_OBJECT (connect_parent, begin_btn, "begin_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image10, "image10");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem2, "toolitem2");
  GLADE_HOOKUP_OBJECT (connect_parent, back_btn, "back_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, back_img, "back_img");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem3, "toolitem3");
  GLADE_HOOKUP_OBJECT (connect_parent, next_btn, "next_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image12, "image12");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem4, "toolitem4");
  GLADE_HOOKUP_OBJECT (connect_parent, last_btn, "last_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image13, "image13");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem5, "toolitem5");
  GLADE_HOOKUP_OBJECT (connect_parent, zoom_out_btn, "zoom_out_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image4, "image4");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem6, "toolitem6");
  GLADE_HOOKUP_OBJECT (connect_parent, zoom_in_btn, "zoom_in_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image6, "image6");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem7, "toolitem7");
  GLADE_HOOKUP_OBJECT (connect_parent, zoom_orig_btn, "zoom_orig_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image15, "image15");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem8, "toolitem8");
  GLADE_HOOKUP_OBJECT (connect_parent, zoom_width_btn, "zoom_width_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image16, "image16");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem9, "toolitem9");
  GLADE_HOOKUP_OBJECT (connect_parent, zoom_fit_btn, "zoom_fit_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image5, "image5");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem10, "toolitem10");
  GLADE_HOOKUP_OBJECT (connect_parent, open_btn, "open_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image8, "image8");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem11, "toolitem11");
  GLADE_HOOKUP_OBJECT (connect_parent, pref_btn, "pref_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image14, "image14");
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem13, "toolitem13");
  GLADE_HOOKUP_OBJECT (connect_parent, quit_btn, "quit_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, image9, "image9");
  GLADE_HOOKUP_OBJECT (connect_parent, rotate_tbtn, "rotate_btn");
  GLADE_HOOKUP_OBJECT (connect_parent, fullscreen_tbtn, "fullscreen_btn");
#if !USE_HILDON
  GLADE_HOOKUP_OBJECT (connect_parent, toolitem14, "toolitem14");
  GLADE_HOOKUP_OBJECT (connect_parent, file_list_tbtn, "file_list_tbtn");
  GLADE_HOOKUP_OBJECT (connect_parent, image17, "image17");
#endif
  GLADE_HOOKUP_OBJECT_NO_REF (nav_toolbar, tooltips, "tooltips");

  return nav_toolbar;
}

GtkWidget*
create_nav_window (void)
{
  GtkWidget *nav_window;
  GtkWidget *nav_toolbar;

  nav_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (nav_window), _("Nav"));
  gtk_window_set_type_hint (GTK_WINDOW (nav_window), GDK_WINDOW_TYPE_HINT_TOOLBAR);

  nav_toolbar = create_toolbar(nav_window);
  gtk_container_add (GTK_CONTAINER (nav_window), nav_toolbar);
  gtk_widget_show (nav_toolbar);
  g_signal_connect ((gpointer) nav_window, "delete_event",
                    G_CALLBACK (on_nav_window_delete_event),
                    NULL);
  g_signal_connect ((gpointer) nav_window, "realize",
                    G_CALLBACK (on_nav_window_realize),
                    NULL);
  GLADE_HOOKUP_OBJECT_NO_REF (nav_window, nav_window, "nav_window");
  return nav_window;
}

GtkWidget*
create_help_popup (void)
{
    GtkWidget* help_popup;
    
    help_popup = gtk_menu_new ();
    create_and_hook_menu_item(help_popup, _("_Go to page..."), on_goto_page_activate);
    create_and_hook_menu_item(help_popup, _("_Advance 1 page"), on_advance_1_page1_activate);
    create_and_hook_menu_item(help_popup, _("A_dvance 2 pages"), on_advance_2_pages1_activate);
    create_and_hook_menu_item(help_popup, _("Go to _end"), on_go_to_end1_activate);
    create_and_hook_menu_item(help_popup, _("_Backup 1 page"), on_backup_1_page1_activate);
    create_and_hook_menu_item(help_popup, _("Ba_ckup 2 pages"), on_backup_2_pages1_activate);
    create_and_hook_menu_item(help_popup, _("Go to _start"), on_go_to_start1_activate);
    gtk_menu_append(help_popup, gtk_separator_menu_item_new());
    create_and_hook_menu_item(help_popup, _("_Zoom to fit"), on_zoom_to_fit1_activate);
#if !USE_HILDON
    create_and_hook_menu_item(help_popup, _("_Enlarge"), on_enlarge1_activate);
    create_and_hook_menu_item(help_popup, _("_Reduce"), on_reduce1_activate);
#endif
    create_and_hook_menu_item(help_popup, _("Or_iginal size"), on_original_size1_activate);
    create_and_hook_menu_item(help_popup, _("Fit to page _width"), on_fit_to_page_width1_activate);
    gtk_menu_append(help_popup, gtk_separator_menu_item_new());
    create_and_hook_menu_item(help_popup, _("Configuration _window"), on_configuration_window1_activate);

    return help_popup;
}

GtkWidget*
create_main_menu(GtkWidget** fullscreen_item_ret)
{
    GtkWidget* main_menu;
    GtkWidget* go_menu;
    GtkWidget* view_menu;
    GtkWidget* tools_menu;
    GtkWidget* fullscreen_item;
    
    main_menu = gtk_menu_new();
    go_menu = gtk_menu_new();
    view_menu = gtk_menu_new();
    tools_menu = gtk_menu_new();

    

    create_and_hook_menu_item(go_menu, _("_Go to page..."), on_goto_page_activate);
    gtk_menu_append(go_menu, gtk_separator_menu_item_new());
    create_and_hook_menu_item(go_menu, _("_Advance 1 page"), on_advance_1_page1_activate);
    create_and_hook_menu_item(go_menu, _("A_dvance 2 pages"), on_advance_2_pages1_activate);
    create_and_hook_menu_item(go_menu, _("Go to _end"), on_go_to_end1_activate);
    gtk_menu_append(go_menu, gtk_separator_menu_item_new());
    create_and_hook_menu_item(go_menu, _("_Backup 1 page"), on_backup_1_page1_activate);
    create_and_hook_menu_item(go_menu, _("Ba_ckup 2 pages"), on_backup_2_pages1_activate);
    create_and_hook_menu_item(go_menu, _("Go to _start"), on_go_to_start1_activate);

    create_and_hook_menu_item(tools_menu, _("_Settings..."), on_configuration_window1_activate);
    /*    create_and_hook_menu_item(tools_menu, _("_Help"), on_about_box_activate);*/
    create_and_hook_menu_item(tools_menu, _("_About..."), on_about_box_activate);
    
    create_and_hook_menu_item(view_menu, _("Zoom to _fit"), on_zoom_to_fit1_activate);
    create_and_hook_menu_item(view_menu, _("_Enlarge"), on_enlarge1_activate);
    create_and_hook_menu_item(view_menu, _("_Reduce"), on_reduce1_activate);
    create_and_hook_menu_item(view_menu, _("_Original size"), on_original_size1_activate);
    create_and_hook_menu_item(view_menu, _("Fit to page _width"), on_fit_to_page_width1_activate);
    gtk_menu_append(view_menu, gtk_separator_menu_item_new());
    fullscreen_item = create_and_hook_check_menu_item(view_menu, _("_Full screen"), on_fullscreen_activate);

    create_and_hook_menu_item(main_menu, _("_Open..."), on_open_activate);
    create_and_hook_submenu(main_menu, _("_Navigation"), go_menu);
    create_and_hook_submenu(main_menu, _("_View"), view_menu);
    create_and_hook_submenu(main_menu, _("_Tools"), tools_menu);
    create_and_hook_menu_item(main_menu, _("_Close"), on_quit_activate);

    if(fullscreen_item_ret)
      *fullscreen_item_ret = fullscreen_item;

    return main_menu;

}


GtkWidget*
create_and_hook_menu_item              (GtkWidget* menu,
					const gchar* label,
					void (*signal_func)(GtkMenuItem*, gpointer))
{
  GtkWidget* retval;
  retval = gtk_menu_item_new_with_mnemonic(label);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu), retval);
  g_signal_connect(G_OBJECT(retval), "activate", G_CALLBACK(signal_func), NULL);
  return retval;
}

GtkWidget*
create_and_hook_check_menu_item        (GtkWidget* menu,
					const char* label,
					void (*signal_func)(GtkMenuItem*, gpointer))
{
  GtkWidget* retval;
  retval = gtk_check_menu_item_new_with_mnemonic(label);
  gtk_menu_shell_append(GTK_MENU_SHELL(menu), retval);
  g_signal_connect(G_OBJECT(retval), "activate", G_CALLBACK(signal_func), NULL);
  return retval;
}  

GtkWidget*
create_and_hook_submenu                (GtkWidget* main_menu,
					const gchar* label,
					GtkWidget* sub_menu)
{
  GtkWidget* retval;
  retval = gtk_menu_item_new_with_mnemonic(label);
  gtk_menu_shell_append(GTK_MENU_SHELL(main_menu), retval);
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(retval), sub_menu);
  return retval;
}

#if USE_HILDON
static
GtkWidget* setup_spinner(GtkWidget* spinner, int current_page, int max_page)
{
  gboolean expand, fill;
  guint padding;
  GtkPackType pack_type;
  GtkWidget* number_editor = hildon_number_editor_new(1, max_page + 1);
  GtkWidget* hbox6 = lookup_widget(spinner, "hbox6");
  hildon_number_editor_set_value(HILDON_NUMBER_EDITOR(number_editor), current_page + 1);
  gtk_widget_show(number_editor);
  /* replace the current spinner with this */
  gtk_box_query_child_packing(GTK_BOX(hbox6),
			      spinner,
			      &expand,
			      &fill,
			      &padding,
			      &pack_type);
  gtk_widget_destroy(spinner);
  if(pack_type == GTK_PACK_START)
    gtk_box_pack_start(GTK_BOX(hbox6), number_editor, expand, fill, padding);
  else
    gtk_box_pack_end(GTK_BOX(hbox6), number_editor, expand, fill, padding);
  gtk_box_reorder_child(GTK_BOX(hbox6), number_editor, 0);
  return number_editor;
}

static
int get_spinner_value(GtkWidget* spinner)
{
  return hildon_number_editor_get_value(HILDON_NUMBER_EDITOR(spinner)) - 1;
}
#else
static
GtkWidget* setup_spinner(GtkWidget* spinner, int current_page, int max_page)
{
  GtkObject* adjustment = gtk_adjustment_new(current_page + 1,
					     1,
					     max_page + 1,
					     1,
					     10,
					     0);
  gtk_spin_button_configure(GTK_SPIN_BUTTON(spinner),
			    GTK_ADJUSTMENT(adjustment),
			    1,
			    0);
  return spinner;
}

static
int get_spinner_value(GtkWidget* spinner)
{
  return gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spinner)) - 1;
}
#endif

int
invoke_goto_page_dialog                (GtkWidget* parent,
					int current_page, 
					int max_page)
{
  GtkWidget* spinner;
  GtkWidget* label;
  gchar* label_content;
  gint response;
  GtkWidget* goto_page_dialog = create_goto_page_dialog();
  int spinner_value = -1;

  gtk_window_set_transient_for(GTK_WINDOW(goto_page_dialog), GTK_WINDOW(parent));

  label = lookup_widget(goto_page_dialog, "page_indicator_label");
  label_content = g_strdup_printf(_("of %d"), max_page + 1);
  gtk_label_set_text(GTK_LABEL(label), label_content);
  g_free(label_content);
  /* find the spinner */
  spinner = lookup_widget(goto_page_dialog, "page_spinner");
  spinner = setup_spinner(spinner, current_page, max_page);
  
  /* hook the dialog */
  gtk_window_set_position(GTK_WINDOW(goto_page_dialog), GTK_WIN_POS_CENTER_ON_PARENT);
  response = gtk_dialog_run(GTK_DIALOG(goto_page_dialog));
  if(response == GTK_RESPONSE_OK) {
    spinner_value = get_spinner_value(spinner);
  }
  gtk_widget_destroy(goto_page_dialog);
  return spinner_value;
}
