// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#include "utils.h"

#include <QFSFileEngine>


QString shortenPath(const QString &path) {
    QString homePath = QFSFileEngine::homePath();

    if (path.indexOf(homePath, 0) == 0) {
        QString result = path;

        result.replace(0, homePath.size(), "~");
        return result;
    }

    return path;
}


QString unwindPath(const QString &path) {
    QString result = path;
    // if ~ is the first character and / or nothing follows it, replace with home dir
    if (path == "~" || path.indexOf("~/", 0) == 0) {
        QString homePath = QFSFileEngine::homePath();
        result.replace(0, 1, homePath);
    // in case someone wants to enter a dir called ~ in the current dir, he can escape it with \~
    } else if (path == "\\~" || path.indexOf("\\~/", 0) == 0) {
        result.replace(0, 2, "~");
    }

    return result;
}


void themeImage(const QPalette &p, QImage &image, const bool inverse) {
    image = image.convertToFormat(QImage::Format_Indexed8);

    QRgb highlight = p.highlight().color().rgb();
    QRgb second;
    if (inverse) {
        second = p.text().color().rgb();
    } else {
        second = p.buttonText().color().rgb();
    }

    QVector<QRgb> colorTable = image.colorTable();
    for (QVector<QRgb>::iterator it = colorTable.begin(); it != colorTable.end(); ++it) {
        if ((*it & 0xFFFFFF) == 0xFFFFFF) *it = (*it & 0xFF000000) | second;
        else if ((*it & 0xFFFFFF) == 0x0000FF) *it = (*it & 0xFF000000) | highlight;
    }
    image.setColorTable(colorTable);
}


bool loadOperationIcons(const QPalette &p, const QString &name, QPixmap &normal, QPixmap &inverse) {
    QImage iconImage(ICON_PATH + ICON_SET + "/" + name + ".xpm", "XPM");
    if (iconImage.isNull()) iconImage.load(ICON_PATH + ICON_SET + "/" + name + ".png", "PNG");
    if (iconImage.isNull()) iconImage.load(ICON_PATH + ICON_SET + "/" + name + ".gif", "GIF");

    QImage inverseIconImage = iconImage;

    themeImage(p, iconImage, false);
    themeImage(p, inverseIconImage, true);

    normal = QPixmap::fromImage(iconImage);
    inverse = QPixmap::fromImage(inverseIconImage);
    return true;
}


bool loadMiddleButtonIcons(const QPalette &p, const QString &name, QIcon &normal, QIcon &mirrored) {
    QImage iconImage(ICON_PATH + ICON_SET + "/" + name + ".xpm", "XPM");
    if (iconImage.isNull()) iconImage.load(ICON_PATH + ICON_SET + "/" + name + ".png", "PNG");
    if (iconImage.isNull()) iconImage.load(ICON_PATH + ICON_SET + "/" + name + ".gif", "GIF");

    themeImage(p, iconImage, false);

    normal = QIcon(QPixmap::fromImage(iconImage));
    mirrored = QIcon(QPixmap::fromImage(iconImage.mirrored(true, false)));
    return true;
}
