// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#ifndef FILEOPERATOR_H
#define FILEOPERATOR_H

#include <QWidget>
#include <QHBoxLayout>

#include "progressbar.h"
#include "operationthread.h"


typedef QList<QPair<OperationThread*, ProgressBar*> > OperationList;

class FileOperator : public QWidget {
    Q_OBJECT

public:
    FileOperator(QWidget *parent = 0);

    void deleteFiles(const QFileInfoList &files);
    void copyFiles(const QFileInfoList &files, QDir &destination);
    void moveFiles(const QFileInfoList &files, QDir &destination);

public slots:
    void showErrorPrompt(OperationThread* op,
        const QString &message,
        const QString &fileName,
        const int err);
    void showOverwritePrompt(OperationThread* op,
        const QString &fileName,
        const bool dirOverDir);
    void showInputFilenamePrompt(OperationThread* op,
        const QFileInfo &fileName,
        const bool dirOverDir);

    void remove(OperationThread* op);

    void togglePauseOperation(ProgressBar* bar);
    void abortOperation(ProgressBar* bar);

protected:
    void initOperation(OperationThread *thread, ProgressBar *bar);
    ProgressBar *get(OperationThread *op) const;
    OperationThread *get(ProgressBar *bar) const;
    void addBarToLayout(ProgressBar *bar);
    void removeBarFromLayout(ProgressBar *bar);

    bool checkMaxOpsNumber();

    OperationList opList;
    QPixmap deleteIcon, inverseDeleteIcon, copyIcon, inverseCopyIcon, moveIcon, inverseMoveIcon;
    QHBoxLayout *topRow, *bottomRow;
};

#endif // FILEOPERATOR_H
