// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#ifndef DIALOG_H
#define DIALOG_H

#include <QDialog>
#include <QDialogButtonBox>
#include <QLabel>


class Dialog : public QDialog {
    Q_OBJECT

public:
    explicit Dialog(QWidget *parent = 0);
    QPushButton *addButtonFirst(const QString &text, QDialogButtonBox::ButtonRole role);
    QPushButton *addButtonFirst(const QDialogButtonBox::StandardButton button);
    QPushButton *addButtonSecond(const QString &text, QDialogButtonBox::ButtonRole role);
    QPushButton *addButtonSecond(const QDialogButtonBox::StandardButton button);

    QAbstractButton *clickedButton;

public slots:
    void finishUp(QAbstractButton *button);
    void setText(const QString &t);
    int exec();

protected:
    QLabel *text;
    QDialogButtonBox *buttons1, *buttons2;
};

#endif // DIALOG_H
