// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#include "button.h"

#include <iostream>

#include "utils.h"


Button::Button(const QString &name, QWidget *parent, const int maxWidth, const int maxHeight) :
    QPushButton(parent),
    iconIndex(0)
{
    setMaximumWidth(maxWidth);
    setMaximumHeight(maxHeight);

    loadMiddleButtonIcons(palette(), name, icons[0], icons[1]);

    setIcon(icons[0]);
}


void Button::swapIcon() {
    iconIndex = (iconIndex + 1) % 2;
    setIcon(icons[iconIndex]);
}
