// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#include "pane.h"

#include <QHeaderView>
#include <QVBoxLayout>
#include <QMessageBox>
#include <QInputDialog>
#include <QDesktopServices>
#include <QUrl>
#include <QProcess>
#include <QPainter>


Pane::Pane(QWidget *theCase, QWidget *parent) :
    QWidget(parent),
    theCase(theCase),
    active(false),
    location(new AddressBar),
    up(new Button("go_up", 0, 70, 60)),
    fileList(new FileList)
{
    QVBoxLayout *layout = new QVBoxLayout;
    layout->setContentsMargins(3, 3, 3, 3);
    layout->setSpacing(0);
    setLayout(layout);

    QHBoxLayout *topLine = new QHBoxLayout;

    location->setText(fileList->path());
    layout->setSpacing(0);

    topLine->addWidget(location);
    topLine->addWidget(up);
    layout->addLayout(topLine);
    layout->addWidget(fileList);

    connect(location, SIGNAL(pathEntered(QString)), fileList, SLOT(changePath(QString)));
    connect(up, SIGNAL(pressed()), fileList, SLOT(goUp()));
    connect(fileList, SIGNAL(pathChanged(QString)), location, SLOT(setText(QString)));

    activationConnect();
}


void Pane::paintEvent(QPaintEvent *) {
    if (active) {
        QPainter painter(this);
        painter.setPen(palette().color(QPalette::Highlight));
        QRect g = this->geometry();
        g.moveTo(1, 1);
        g.setWidth(g.width() - 3);
        g.setHeight(g.height() - 3);
        painter.drawRect(g);
    }
}


void Pane::activationConnect() {
    connect(up, SIGNAL(clicked()), theCase, SLOT(switchActivePane()));
    connect(location, SIGNAL(mousePressed()), theCase, SLOT(switchActivePane()));
    connect(fileList, SIGNAL(mousePressed()), theCase, SLOT(switchActivePane()));
}


void Pane::activationDisconnect() {
    disconnect(up, SIGNAL(clicked()), theCase, SLOT(switchActivePane()));
    disconnect(location, SIGNAL(mousePressed()), theCase, SLOT(switchActivePane()));
    disconnect(fileList, SIGNAL(mousePressed()), theCase, SLOT(switchActivePane()));
}


void Pane::toggleActive() {
    active = !active;
    if (active) activationDisconnect(); else activationConnect();
    update();
}


void Pane::toggleShowHiddenFiles() {
    fileList->toggleShowHiddenFiles();
}


const QFileInfoList Pane::selection() const {
    return fileList->selection();
}


bool Pane::changePath(QString path) {
    location->setText(path);
    return fileList->changePath(path);
}


const QString Pane::path() const {
    return fileList->path();
}
