// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#include "dialog.h"

#include <QHBoxLayout>


Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    text(new QLabel()),
    buttons1(new QDialogButtonBox(Qt::Vertical)),
    buttons2(new QDialogButtonBox(Qt::Vertical))
{
    text->setWordWrap(true);
    text->setAlignment(Qt::AlignTop | Qt::AlignLeft);

    QHBoxLayout *layout = new QHBoxLayout();
    setLayout(layout);
    layout->addWidget(text);

    connect(buttons1, SIGNAL(clicked(QAbstractButton*)), this, SLOT(finishUp(QAbstractButton*)));
    connect(buttons2, SIGNAL(clicked(QAbstractButton*)), this, SLOT(finishUp(QAbstractButton*)));
}


QPushButton *Dialog::addButtonFirst(const QString &text, QDialogButtonBox::ButtonRole role) {
    return buttons1->addButton(text, role);
}


QPushButton *Dialog::addButtonFirst(const QDialogButtonBox::StandardButton button) {
    return buttons1->addButton(button);
}


QPushButton *Dialog::addButtonSecond(const QString &text, QDialogButtonBox::ButtonRole role) {
    return buttons2->addButton(text, role);
}


QPushButton *Dialog::addButtonSecond(const QDialogButtonBox::StandardButton button) {
    return buttons2->addButton(button);
}


void Dialog::setText(const QString &t) {
    text->setText(t);
}


void Dialog::finishUp(QAbstractButton *button) {
    clickedButton = button;
    done(0);
}


int Dialog::exec() {
    QHBoxLayout *l = qobject_cast<QHBoxLayout*>(layout());
    if (buttons1->buttons().size()) {
        l->addWidget(buttons1, 0, Qt::AlignTop);
    }
    if (buttons2->buttons().size()) {
        l->addWidget(buttons2, 0, Qt::AlignTop);
    }
    return QDialog::exec();
}
