// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#include "button.h"

#include <iostream>

#define ICON_PATH QString("/usr/share/pixmaps/case/")
#define ICON_SET "default"


Button::Button(const QString &name, QWidget *parent, const int maxWidth, const int maxHeight) :
    QPushButton(parent),
    iconIndex(0)
{
    setMaximumWidth(maxWidth);
    setMaximumHeight(maxHeight);

    QImage iconImage(ICON_PATH + ICON_SET + "/" + name + ".xpm", "XPM");
    if (iconImage.isNull()) iconImage.load(ICON_PATH + ICON_SET + "/" + name + ".png", "PNG");
    if (iconImage.isNull()) iconImage.load(ICON_PATH + ICON_SET + "/" + name + ".gif", "GIF");

    iconImage = iconImage.convertToFormat(QImage::Format_Indexed8);

    QRgb buttonText = palette().color(QPalette::ButtonText).rgb();
    QRgb highlight = palette().color(QPalette::Highlight).rgb();
    QVector<QRgb> colorTable = iconImage.colorTable();
    for (QVector<QRgb>::iterator it = colorTable.begin(); it != colorTable.end(); ++it) {
        if ((*it & 0xFFFFFF) == 0xFFFFFF) *it = (*it & 0xFF000000) | buttonText;
        else if ((*it & 0xFFFFFF) == 0x0000FF) *it = (*it & 0xFF000000) | highlight;
    }
    iconImage.setColorTable(colorTable);

    icons[0] = QIcon(QPixmap::fromImage(iconImage));
    icons[1] = QIcon(QPixmap::fromImage(iconImage.mirrored(true, false)));

    setIcon(icons[0]);
}


void Button::swapIcon() {
    iconIndex = (iconIndex + 1) % 2;
    setIcon(icons[iconIndex]);
}
