// case - file manager for N900
// Copyright (C) 2010 Lukas Hrazky <lukkash@email.cz>
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.


#ifndef CASE_H
#define CASE_H

#include "pane.h"
#include "fileoperator.h"
#include "button.h"

#include <QMainWindow>
#include <QKeyEvent>


class Case : public QMainWindow {
    Q_OBJECT

signals:
    void activePaneSwitched();

public:
    Case(QWidget *parent = 0);

public slots:
    void switchActivePane();

protected:
    void keyPressEvent(QKeyEvent *e);

    Pane *leftPane, *rightPane, *activePane, *inactivePane;
    Button *cloneBtn, *swapBtn, *copyBtn, *moveBtn, *delBtn;
    FileOperator *fileOperator;

protected slots:
    void clonePane();
    void swapPanes();
    void copyFiles();
    void moveFiles();
    void deleteFiles();
};

#endif // CASE_H
