#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

#import logging

from terra.core.manager import Manager
from terra.utils.encoding import to_utf8

from model import PhotocastModelFolder, PhotocastFeedModelFolder

__all__ = ("SettingsPhotocastModelFolder",
           "SettingsPhotocastFolderController", )


#log = logging.getLogger("plugins.canola-core.photocast.settings")
mger = Manager()

settings_feed_folder_controller_cls = \
    mger.get_class("Controller/Settings/Folder/Feed")


class SettingsPhotocastModelFolder(PhotocastModelFolder):
    terra_type = "Model/Settings/Folder/InternetMedia/Photocast"
    title = "Photocasts"
    select_order = "ORDER BY epoch DESC"

    def item_new(self, uri, contents):
        feed = contents.feed
        title = to_utf8(feed.title)

        if feed.has_key("description"):
            desc = to_utf8(feed.description)
        else:
            desc = ""

        if feed.has_key("author_detail") and feed.author_detail.has_key("name"):
            author = feed.author_detail.name
        elif feed.has_key("author"):
            author = feed.author
        else:
            author = ""

        item = PhotocastFeedModelFolder(None, uri, title, desc, author)
        item.commit()
        return item

    def child_model_exists_in_db(self, uri):
        rows = mger.canola_db.execute(PhotocastFeedModelFolder.stmt_exists, (uri, ))
        if rows:
            return rows[0]
        else:
            return None


class SettingsPhotocastFolderController(settings_feed_folder_controller_cls):
    terra_type = "Controller/Settings/Folder/InternetMedia/Photocast"
