#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

#import logging

from terra.core.manager import Manager
from terra.core.plugin_prefs import PluginPrefs
from terra.utils.encoding import to_utf8

from model import VideoFeedFolder, VideoOnDemandFolder

__all__ = ("SettingsVideocastModelFolder", "SettingsVideocastFolderController", )

#log = logging.getLogger("plugins.canola-core.ondemand.video.settings")

mger = Manager()
settings = PluginPrefs("settings")

DownloadManager = mger.get_class("DownloadManager")
download_mger = DownloadManager()


class SettingsVideocastModelFolder(VideoFeedFolder):
    terra_type = "Model/Settings/Folder/InternetMedia/Videocast"
    title = "Videocasts"
    select_order = "ORDER BY epoch DESC"

    def item_new(self, uri, contents):
        feed = contents.feed
        title = to_utf8(feed.title)
        if feed.has_key("description"):
            desc = to_utf8(feed.description)
        else:
            desc = ""

        item = VideoOnDemandFolder(title, uri)
        item.desc = desc
        item.commit() # sets id and cover path

        item.fetch_cover(contents)

        return item

SettingsFeedFolderController = \
    mger.get_class("Controller/Settings/Folder/Feed")
class SettingsVideocastFolderController(SettingsFeedFolderController):
    terra_type = "Controller/Settings/Folder/InternetMedia/Videocast"

    acceptable_mime_types = [
        'application/rss+xml',
        'application/xml', # Some feeds return this
        'text/xml',  # This one is due to Feedburner
        'text/html', # Sadly required for some feeds :-(
        'application/atom+xml', 'application/atom',
        'text/xml+rss'
    ]
