# -*- coding: utf-8 -*-
#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# Additional permission under GNU GPL version 3 section 7
#
# The copyright holders grant you an additional permission under Section 7
# of the GNU General Public License, version 3, exempting you from the
# requirement in Section 6 of the GNU General Public License, version 3, to
# accompany Corresponding Source with Installation Information for the
# Program or any work based on the Program. You are still required to comply
# with all other Section 6 requirements to provide Corresponding Source.
#

from downloadmanager.constants import DownloadState

(
    STATE_INITIAL,
    STATE_DOWNLOAD_DIALOG_OPENING,
    STATE_DOWNLOADING,
    STATE_PAUSED,
    STATE_DOWNLOADED,
    STATE_QUEUED,
) = range(6)

state_mapping = {
   STATE_INITIAL: [
       DownloadState.NOT_STARTED,
       DownloadState.CANCELLED,
       DownloadState.FILTERED,
       DownloadState.EXCEPTION
    ],
    STATE_DOWNLOADING: [
       DownloadState.CONNECTING,
       DownloadState.IN_PROGRESS,
       DownloadState.QUEUED
    ],
    STATE_PAUSED: [
       DownloadState.PAUSED
    ],
    STATE_DOWNLOADED: [
       DownloadState.COMPLETED
    ]
}
