//{{{
/*
 * NOTE
 *    This file uses folding extensively, and it is *extremely* awkward to edit
 * without it. See data/items.m4 for information on configuring your editor.
 */
//}}}
#include "maps.m4h"

m4_divert(SEQUENCE_TABLES)
even;
export MAPTABLE;
//////////////////////////////////////////////////////////////////////////////
//  Name            Desc                        Monsters                    //
//  Flags                                                                   //
//  Diff  Items          Population Generation              Generation      //
//  Entrance                                                                //
//{{{
MAP(SURFACE,        gettext("the surface"),     NULL,
    MAPFLAG_OUTSIDE,
    0,    range(13,9),   0,         NULL,                   NULL,
    NULL)
//}}}
//{{{
MAP(START_DLVL1,    gettext("level 1"),         MONSTERTABLE,
    0,
    1,    range(13,9),   2,         MAPGEN_DUNGEON,         map_normal_dungeon,
    enter_level,
    {@LINKUP(MAP_SURFACE) LINKDN(MAP_START_DLVL2) @})
//}}}
//{{{
MAP(START_DLVL2,    gettext("level 2"),         MONSTERTABLE,
    0,
    2,    range(13,9),   6,         MAPGEN_DUNGEON,         map_normal_dungeon,
    enter_level,
    {@LINKUP(MAP_START_DLVL1) LINKDN(MAP_START_DLVL3)@})
//}}}
//{{{
MAP(START_DLVL3,    gettext("level 3"),         MONSTERTABLE,
    0,
    3,    range(30,25),  50,        MAPGEN_LARGEDUNGEON,    map_big_dungeon,
    enter_level,
    {@LINKUP(MAP_START_DLVL2) LINKDN(MAP_START_DLVL4)@})
//}}}
//{{{
MAP(START_DLVL4,    gettext("level 4"),         MONSTERTABLE,
    0,
    4,    range(13,9),   13,        MAPGEN_DUNGEON,         map_cave,
    enter_level,
    {@LINKUP(MAP_START_DLVL3) LINKDN(MAP_START_DLVL5)@})
//}}}
//{{{
MAP(START_DLVL5,    gettext("level 5"),         MONSTERTABLE,
    0,
    5,    range(13,9),   15,        MAPGEN_ORACLE,          map_oracle,
    enter_level,
    {@LINKUP(MAP_START_DLVL4)
      MAPCONN(TILE_STAIRUP, coord(32,8), MAP_MAINTOWN, coord(30,3))
      MAPFOUNTAIN(coord(33,9), FOUNTAIN_INFO(FOUNTAIN_DEPLETED_COLD, 0))
      MAPFOUNTAIN(coord(31,9), FOUNTAIN_INFO(FOUNTAIN_DEPLETED_COLD, 0))
      MAPFOUNTAIN(coord(32,10), FOUNTAIN_INFO(FOUNTAIN_DEPLETED_COLD, 0))
      MAPLINK(MAPSPEC_MONSTER, coord(32,9), MONSTER_ORACLE) @})
//}}}
//{{{
MAP(MAINTOWN,       gettext("town"),            MONSTERTABLE,
    MAPFLAG_NORANDMONST,
    1,    range(0,0),    0,         MAPGEN_MAINTOWN,        map_fixed,
    enter_town,
    {@MAPLINK(MAPSPEC_MONSTER, coord(42,8), MONSTER_SHOPKEEPER)
      MAPLINK(MAPSPEC_MONSTER, coord(43,15), MONSTER_SHOPKEEPER)
      MAPLINK(MAPSPEC_MONSTER, coord(53,15), MONSTER_SHOPKEEPER)
      MAPCONNFILL(coord(28,18), MAP_WILDERNESS, coord(8,4))
      MAPLINK(MAPSPEC_MONSTER, coord(55,7), MONSTER_ELDER)
      MAPLINK(MAPSPEC_MONSTER, coord(14,2), MONSTER_FISHERMAN)
      MAPLINK(MAPSPEC_MONSTER, coord(39,2), MONSTER_FISHERMAN)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      @}) 
//}}}
//{{{
MAP(WILDERNESS,     gettext("wilderness"),      MONSTERTABLE,
    MAPFLAG_NOMONST|MAPFLAG_NORANDMONST|MAPFLAG_NOTELEPORT,
    1,    range(0,0),    0,         MAPGEN_WILDERNESS,      build_wilderness,
	enter_wilderness,
    {@MAPCONN(TILE_TOWN, coord(8,3), MAP_MAINTOWN, coord(29,17))
      MAPCONN(TILE_TOWN, coord(23,11), MAP_CITY, coord(62,11))
      MAPCONN(TILE_FORESTCONN, coord(23,4), MAP_FOREST, coord(3,5))
      MAPCONN(TILE_FORESTCONN, coord(23,5), MAP_FOREST, coord(3,18))
      MAPCONN(TILE_BRIDGECONN, coord(26,6), MAP_FOREST, coord(52,23))
      MAPCONN(TILE_CAVE, coord(36,8), MAP_CAVE1, coord(1,9))
      MAPCONN(TILE_CAVE, coord(38,7), MAP_CAVE5, coord(62,9))
      MAPCONN(TILE_CAVE, coord(41,9), MAP_DLVL1, coord(0,0))
      MAPCONN(TILE_CAVE, coord(40,7), MAP_DWARFTOWN, coord(1,18))
      MAPCONN(TILE_CAVE, coord(1,12), MAP_DRAGONLAIR, coord(62,9))
      MAPCONN(TILE_CAVE, coord(8,13), MAP_TOWER1, coord(10,10))
    @}) 
//}}}
//{{{
MAP(FOREST,         gettext("forest"),          MONSTERTABLE,
    0,
    5,    range(13,9),   15,        MAPGEN_FOREST,          build_forest,
	enter_forest,
    {@MAPCONNFILL(coord(2,4), MAP_WILDERNESS, coord(22,4))
      MAPCONNFILL(coord(2,17), MAP_WILDERNESS, coord(22,5))
      MAPCONNFILL(coord(52,24), MAP_WILDERNESS, coord(26,7))
    @})
//}}}
//{{{
MAP(CITY,           gettext("city"),            MONSTERTABLE,
    MAPFLAG_NORANDMONST,
    1,    range(0,0),    0,         MAPGEN_CITY,            build_city,
	enter_level,
    {@MAPCONNFILL(coord(4,0), MAP_WILDERNESS, coord(22,10))
      MAPCONNFILL(coord(13,0), MAP_WILDERNESS, coord(23,10))
      MAPCONNFILL(coord(25,0), MAP_WILDERNESS, coord(23,10))
      MAPCONNFILL(coord(30,0), MAP_WILDERNESS, coord(23,10))
      MAPCONNFILL(coord(36,0), MAP_WILDERNESS, coord(23,10))
      MAPCONNFILL(coord(42,0), MAP_WILDERNESS, coord(23,10))
      MAPCONNFILL(coord(51,0), MAP_WILDERNESS, coord(23,10))
      MAPCONNFILL(coord(59,0), MAP_WILDERNESS, coord(24,10))
      MAPCONNFILL(coord(0,10), MAP_WILDERNESS, coord(22,11))
      MAPCONNFILL(coord(63,10), MAP_WILDERNESS, coord(24,11))
      MAPCONNFILL(coord(4,19), MAP_WILDERNESS, coord(22,12))
      MAPCONNFILL(coord(17,19), MAP_WILDERNESS, coord(23,12))
      MAPCONNFILL(coord(25,19), MAP_WILDERNESS, coord(23,12))
      MAPCONNFILL(coord(30,19), MAP_WILDERNESS, coord(23,12))
      MAPCONNFILL(coord(44,19), MAP_WILDERNESS, coord(23,12))
      MAPCONNFILL(coord(55,19), MAP_WILDERNESS, coord(24,12))
      MAPLINK(MAPSPEC_MONSTER, coord(21,3), MONSTER_SHOPKEEPER)
      MAPLINK(MAPSPEC_ITEM, coord(21,1), GENERATE_SCROLL)
      MAPLINK(MAPSPEC_ITEM, coord(21,2), GENERATE_SCROLL)
      MAPLINK(MAPSPEC_ITEM, coord(22,1), GENERATE_SCROLL)
      MAPLINK(MAPSPEC_ITEM, coord(22,2), GENERATE_SCROLL)
      MAPLINK(MAPSPEC_ITEM, coord(23,1), GENERATE_BOOK)
      MAPLINK(MAPSPEC_ITEM, coord(23,2), GENERATE_BOOK)
      MAPLINK(MAPSPEC_MONSTER, coord(8,14), MONSTER_SHOPKEEPER)
      MAPLINK(MAPSPEC_ITEM, coord(7,13), ITYPE_POTION_BOTTLE)
      MAPLINK(MAPSPEC_ITEM, coord(6,14), ITYPE_POTION_BOTTLE)
      MAPLINK(MAPSPEC_ITEM, coord(7,14), ITYPE_SCROLL_BLANK)
      MAPLINK(MAPSPEC_ITEM, coord(7,15), GENERATE_RING)
      MAPLINK(MAPSPEC_MONSTER, coord(46,5), MONSTER_HORSE)
      MAPLINK(MAPSPEC_MONSTER, coord(47,5), MONSTER_HORSE)
      MAPLINK(MAPSPEC_MONSTER, coord(48,5), MONSTER_HORSE)
      MAPLINK(MAPSPEC_MONSTER, coord(48,7), MONSTER_STABLE_SALESMAN)
      MAPLINK(MAPSPEC_MONSTER, coord(47,15), MONSTER_SMITHY)
      MAPLINK(MAPSPEC_MONSTER, coord(16,5), MONSTER_MAYOR)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
      MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_COMMONER)
    @})
//}}}
//{{{
MAP(CAVE1,          gettext("a cave"),          MONSTERTABLE,
    MAPFLAG_EASYDIGGING,
    6,    range(13,9),   12,        MAPGEN_CAVE_LEFT,       build_mine,
	enter_level,
    {@MAPCONNFILL(coord(0,8), MAP_WILDERNESS, coord(35,8))
      LINKDN(MAP_CAVE2)
    @})
//}}}
//{{{
MAP(CAVE2,          gettext("a cave"),          MONSTERTABLE,
    MAPFLAG_EASYDIGGING,
    7,    range(13,9),   12,        MAPGEN_CAVE_RIGHT,      build_mine,
	enter_level,
    {@MAPCONNFILL(coord(63,8), MAP_CAVE3, coord(1,9))
      LINKUP(MAP_CAVE1)
    @})
//}}}
//{{{
MAP(CAVE3,          gettext("a cave"),          MONSTERTABLE,
    MAPFLAG_EASYDIGGING,
    8,    range(13,9),   12,        MAPGEN_CAVE_JUNCT_N_W,  build_cave,
	enter_level,
    {@MAPCONNFILL(coord(0,9), MAP_CAVE2, coord(62,9))
      MAPCONNFILL(coord(31,0), MAP_CAVE4, coord(31,18))
    @})
//}}}
//{{{
MAP(CAVE4,          gettext("a cave"),          MONSTERTABLE,
    MAPFLAG_EASYDIGGING,
    9,    range(13,9),   12,        MAPGEN_CAVE_DOWN,       build_mine,
	enter_level,
    {@MAPCONNFILL(coord(31,19), MAP_CAVE3, coord(31,1))
      LINKUP(MAP_CAVE5)
    @})
//}}}
//{{{
MAP(CAVE5,          gettext("a cave"),          MONSTERTABLE,
    MAPFLAG_EASYDIGGING,
    9,    range(13,9),   12,        MAPGEN_CAVE_RIGHT,      build_mine,
	enter_level,
    {@MAPCONNFILL(coord(63,9), MAP_WILDERNESS, coord(39,7))
      LINKDN(MAP_CAVE4)
    @})
//}}}
//{{{
MAP(DWARFTOWN,      gettext("dwarfish town"),   MONSTERTABLE,
    MAPFLAG_NORANDMONST,
    1,    range(0,0),    0,         MAPGEN_DWARFTOWN,       build_dwarftown,
	enter_level,
	{@MAPCONNFILL(coord(0,10), MAP_WILDERNESS, coord(39,7))
	  MAPCONNFILL(coord(0,19), MAP_WILDERNESS, coord(39,8))
	  MAPCONNFILL(coord(24,19), MAP_WILDERNESS, coord(40,8))
	  MAPLINK(MAPSPEC_MONSTER, coord(7,6), MONSTER_SHOPKEEPER)
	  MAPLINK(MAPSPEC_MONSTER, coord(32,18), MONSTER_SMITHY)
	  MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_DWARF)
	  MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_DWARF)
	  MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_DWARF)
	  MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_DWARF)
	  MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_DWARF)
	  MAPLINK(MAPSPEC_MONSTER, coord(0,0), MONSTER_DWARF)
	  MAPLINK(MAPSPEC_MONSTER, coord(14,12), MONSTER_THUNRARR)
	@})
//}}}
//{{{
MAP(DLVL1,          gettext("level 1"),         MONSTERTABLE,
    0,
    10,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@MAPCONN(TILE_STAIRUP, coord(0,0), MAP_WILDERNESS, coord(41,8))
	  LINKDN(MAP_DLVL2)
	@})
//}}}
//{{{
MAP(DLVL2,          gettext("level 2"),         MONSTERTABLE,
    0,
    11,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL1) LINKDN(MAP_DLVL3) @})
//}}}
//{{{
MAP(DLVL3,          gettext("level 3"),         MONSTERTABLE,
    0,
    12,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL2) LINKDN(MAP_DLVL4) @})
//}}}
//{{{
MAP(DLVL4,          gettext("level 4"),         MONSTERTABLE,
    0,
    13,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL3) LINKDN(MAP_DLVL5) @})
//}}}
//{{{
MAP(DLVL5,          gettext("level 5"),         MONSTERTABLE,
    0,
    14,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL4) LINKDN(MAP_DLVL6) @})
//}}}
//{{{
MAP(DLVL6,          gettext("level 6"),         MONSTERTABLE,
    0,
    15,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL5) LINKDN(MAP_DLVL7) @})
//}}}
//{{{
MAP(DLVL7,          gettext("level 7"),         MONSTERTABLE,
    0,
    16,   range(13,9),   15,        MAPGEN_BIGROOM,         map_bigroom,
	enter_level,
    {@ LINKUP(MAP_DLVL6) LINKDN(MAP_DLVL8) @})
//}}}
//{{{
MAP(DLVL8,          gettext("level 8"),         MONSTERTABLE,
    0,
    17,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL7) LINKDN(MAP_DLVL9) @})
//}}}
//{{{
MAP(DLVL9,          gettext("level 9"),         MONSTERTABLE,
    0,
    18,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL8) LINKDN(MAP_DLVL10) @})
//}}}
//{{{
MAP(DLVL10,         gettext("level 10"),        MONSTERTABLE,
    0,
    19,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL9) LINKDN(MAP_DLVL11) @})
//}}}
//{{{
MAP(DLVL11,         gettext("level 11"),        MONSTERTABLE,
    0,
    20,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL10) LINKDN(MAP_DLVL12) @})
//}}}
//{{{
MAP(DLVL12,         gettext("level 12"),        MONSTERTABLE,
    0,
    21,   range(13,9),   15,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL11) LINKDN(MAP_DLVL13) @})
//}}}
//{{{
MAP(DLVL13,         gettext("level 13"),        MONSTERTABLE,
    0,
    22,   range(13,9),   17,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL12) LINKDN(MAP_DLVL14) @})
//}}}
//{{{
MAP(DLVL14,         gettext("level 14"),        MONSTERTABLE,
    0,
    23,   range(13,9),   22,        MAPGEN_DUNGEON,         MAPFUNC_DUNGEON,
	enter_level,
    {@ LINKUP(MAP_DLVL13) LINKDN(MAP_DLVL15) @})
//}}}
//{{{
MAP(DLVL15,         gettext("level 15"),        MONSTERTABLE,
    0,
    24,   range(60,50),  100,       MAPGEN_BIGDUNGEON,      map_big_dungeon,
	enter_level,
    {@ LINKUP(MAP_DLVL14)
       MAPLINK(MAPSPEC_ITEM, coord(0,0), ITYPE_AMULET_YENDOR)
    @})
//}}}

//{{{
MAP(DRAGONLAIR,     gettext("cave"),            MONSTERTABLE_DRAGONCAVE,
    MAPFLAG_EASYDIGGING,
    10,   range(8,5),    8,         MAPGEN_DRAGONCAVE,      build_cave,
	enter_dragon_lair,
	{@MAPCONNFILL(coord(63,9), MAP_WILDERNESS, coord(2,12))
	@})
//}}}
//{{{
MAP(TOWER1,         gettext("tower 1"),         MONSTERTABLE_WIZARDSTOWER,
    0,
    10,   range(5,3),    4,         MAPGEN_TOWER,           build_tower,
	enter_wizards_tower,
	{@ MAPCONN(TILE_STAIRDN, coord(10,10), MAP_WILDERNESS, coord(9,13))
       MAPCONN(MAPSPEC_USER2, coord(0,0), MAP_TOWER2, coord(0,0))
	@})
//}}}
//{{{
MAP(TOWER2,         gettext("tower 2"),         MONSTERTABLE_WIZARDSTOWER,
    0,
    10,   range(5,3),    4,         MAPGEN_TOWER,           build_tower,
	enter_level,
	{@
	  MAPCONN(MAPSPEC_USER1, coord(0,0), MAP_TOWER1, coord(0,0))
	  MAPCONN(MAPSPEC_USER2, coord(0,0), MAP_TOWER3, coord(0,0))
	@})
//}}}
//{{{
MAP(TOWER3,         gettext("tower 3"),         MONSTERTABLE_WIZARDSTOWER,
    0,
    10,   range(5,3),    4,         MAPGEN_TOWER,           build_tower,
	enter_level,
	{@
	  MAPCONN(MAPSPEC_USER1, coord(0,0), MAP_TOWER2, coord(0,0))
	  MAPCONN(MAPSPEC_USER2, coord(0,0), MAP_TOWER4, coord(0,0))
	@})
//}}}
//{{{
MAP(TOWER4,         gettext("tower 4"),         MONSTERTABLE_WIZARDSTOWER,
    0,
    10,   range(5,3),    4,         MAPGEN_TOWER,           build_tower,
	enter_level,
	{@
	  MAPCONN(MAPSPEC_USER1, coord(0,0), MAP_TOWER3, coord(0,0))
	  MAPCONN(MAPSPEC_USER2, coord(0,0), MAP_TOWER5, coord(0,0))
	@})
//}}}
//{{{
MAP(TOWER5,         gettext("tower 5"),         MONSTERTABLE_WIZARDSTOWER,
    0,
    10,   range(5,3),    4,         MAPGEN_TOWER,           build_tower,
	enter_level,
	{@
	  MAPCONN(MAPSPEC_USER1, coord(0,0), MAP_TOWER4, coord(0,0))
	  MAPCONN(MAPSPEC_USER2, coord(0,0), MAP_TOWER_TOP, coord(0,0))
	@})
//}}}
//{{{
MAP(TOWER_TOP,      gettext("tower 6"),         MONSTERTABLE_WIZARDSTOWER,
    0,
    10,   range(0,0),    4,         MAPGEN_TOWER_TOP,       build_tower_top,
	enter_level,
	{@
	  MAPCONN(MAPSPEC_USER1, coord(0,0), MAP_TOWER5, coord(0,0))
      MAPCONN(TILE_STAIRUP, coord(10,2), MAP_TOWER_ROOF, coord(10,2))
      MAPLINK(MAPSPEC_ITEM, coord(1,8), ITYPE_BOOK_BASIC_SPELLS)
      MAPLINK(MAPSPEC_ITEM, coord(1,9), ITYPE_BOOK_LIFE_SPELLS)
      MAPLINK(MAPSPEC_ITEM, coord(1,10), ITYPE_BOOK_MISC_SPELLS)
      MAPLINK(MAPSPEC_ITEM, coord(1,11), ITYPE_BOOK_CHANNELING_SPELLS)
      MAPLINK(MAPSPEC_ITEM, coord(1,12),  ITYPE_BOOK_LICHDOM)
      MAPLINK(MAPSPEC_ITEM, coord(2,7),  ITYPE_BOOK_ANIMATION)
      MAPLINK(MAPSPEC_ITEM, coord(3,7),  ITYPE_BOOK_REPAIRS)
      MAPLINK(MAPSPEC_ITEM, coord(4,7),  ITYPE_BOOK_ELEMENTAL_SPELLS)
	  MAPKEY(ITYPE_LIBRARY_KEY)
	@})
//}}}
//{{{
MAP(TOWER_ROOF,     gettext("tower roof"),      MONSTERTABLE_WIZARDSTOWER,
    MAPFLAG_NORANDMONST,
    10,   range(0,0),    0,         MAPGEN_TOWER_ROOF,      build_tower_roof,
	enter_tower_roof,
	{@
      MAPCONN(TILE_STAIRDN, coord(10,2), MAP_TOWER_TOP, coord(10,2))
      MAPCONNFILL(coord(1,1), MAP_WILDERNESS, coord(9,13))
	  MAPLINK(MAPSPEC_MONSTER, coord(10,8), MONSTER_LICH)
	@})
//}}}

//{{{
MAP(TUTORIAL,       gettext("tutorial"),        MONSTERTABLE,
    MAPFLAG_NORANDMONST|MAPFLAG_NOMONST,
    1,    range(0,0),    0,         MAPGEN_TUTORIAL,        map_fixed_all,
	enter_level,
    {@MAPCONN(TILE_STAIRUP, coord(4,4), MAP_SURFACE, coord(0,0))
      MAPSIGN({@coord(4,4)@}, 0)
      MAPSIGN({@coord(10,4)@}, 1)
      MAPSIGN({@coord(10,6)@}, 2)
      MAPLINK(MAPSPEC_ITEM, coord(9,9), ITYPE_WEAPON_SWORD)
      MAPSIGN({@coord(7,10)@}, 3)
      MAPLINK(MAPSPEC_MONSTER, coord(2,8), MONSTER_SNAKE)
      MAPSIGN({@coord(3,11)@}, 4)
      MAPLINK(MAPSPEC_ITEM, coord(3,15), ITYPE_WAND_DIGGING)
      MAPSIGN({@coord(4,15)@}, 5)
      MAPSIGN({@coord(11,14)@}, 6)
      MAPLINK(MAPSPEC_ITEM, coord(11,13), ITYPE_WEAPON_BOW)
      MAPLINK(MAPSPEC_ITEM, coord(12,13), ITYPE_AMMO_ARROW)
      MAPLINK(MAPSPEC_MONSTER, coord(17,14), MONSTER_BAT)
      MAPLINK(MAPSPEC_MONSTER, coord(17,15), MONSTER_BAT)
      MAPLINK(MAPSPEC_MONSTER, coord(18,14), MONSTER_BAT)
      MAPLINK(MAPSPEC_MONSTER, coord(18,15), MONSTER_BAT)
      MAPSIGN({@coord(13,10)@}, 7)
      MAPLINK(MAPSPEC_ITEM, coord(13,9), ITYPE_BOOK_TUTORIAL)
      MAPSIGN({@coord(14,5)@}, 8)
      MAPLINK(MAPSPEC_ITEM, coord(13,5), ITYPE_GOLD_PIECE)
      MAPSIGN({@coord(14,3)@}, 9)
      MAPLINK(MAPSPEC_ITEM, coord(13,3), ITYPE_RING_STRENGTH)
      MAPSIGN({@coord(17,3)@}, 10)
      MAPLINK(MAPSPEC_ITEM, coord(18,3), ITYPE_ARMR_CHAIN)
      MAPSIGN({@coord(22,6)@}, 11)
      MAPSIGN({@coord(25,16)@}, 12)
      MAPCONN(TILE_STAIRUP, coord(26,16), MAP_SURFACE, coord(0,0)) @})
//}}}


//{{{
BEGIN_JUMPTAB(MAPFUNC_DUNGEON, jt_unconditional)
  JTENTRY(map_normal_dungeon,    15, range(255,1))
  JTENTRY(map_packed_dungeon,    5,  range(255,1))
  JTENTRY(map_cave,              1,  range(255,1))
END_JUMPTAB()
//}}}
//{{{
BEGIN_JUMPTAB(MAPFUNC_HARDDUNGEON, jt_unconditional)
  JTENTRY(map_packed_dungeon,    1,  range(255,1))
  JTENTRY(map_cave,              1,  range(255,1))
END_JUMPTAB()
//}}}
//{{{
BEGIN_JUMPTAB(MAPGEN_BIGROOM, jt_unconditional)
  JTENTRY(MAPGEN_BIGROOM1,      1,  range(255,1))
  JTENTRY(MAPGEN_BIGROOM2,      1,  range(255,1))
  JTENTRY(MAPGEN_BIGROOM3,      1,  range(255,1))
END_JUMPTAB()
//}}}
//{{{
BEGIN_JUMPTAB(MAPGEN_TOWER, jt_unconditional)
  JTENTRY(MAPGEN_TOWER1,      1,  range(255,1))
  JTENTRY(MAPGEN_TOWER2,      1,  range(255,1))
  JTENTRY(MAPGEN_TOWER3,      1,  range(255,1))
  JTENTRY(MAPGEN_TOWER4,      1,  range(255,1))
  JTENTRY(MAPGEN_TOWER5,      1,  range(255,1))
  JTENTRY(MAPGEN_TOWER6,      1,  range(255,1))
  JTENTRY(MAPGEN_TOWER7,      1,  range(255,1))
  JTENTRY(MAPGEN_TOWER8,      1,  range(255,1))
END_JUMPTAB()
//}}}

//{{{
GEN_MAP(TUTORIAL,       0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW....W....WW......W....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW.<.......WW.t..t.W....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW..t.W...tWW......W....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWWW+WWW.t....+....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWW...tWW......W..t.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW....W....WWWW.WWWWWW.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW....W....WW....WWWWW.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW....+....WW....WWWWW.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW....Wt...WWt...WWWWW.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW.t..W....WW....WWWWW.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWXWWWWWWWWWWW+WWWWWW.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW...###.....WW.....WW.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW...###...t.WW.....WW.WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW..t###.....+......WW.W....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW...###.....WW.....WW.W....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WW...###.....WW.....WW.+....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWWWWW....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(DUNGEON,        0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
  @})
//}}}
//{{{
GEN_MAP(LARGEDUNGEON,   0,
	64, 48,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "W##############################################################W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
  @})
//}}}
//{{{
GEN_MAP(BIGDUNGEON,     0,
	96, 96,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "W##############################################################################################W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
  @})
//}}}
//{{{
GEN_MAP(ORACLE,         0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W???????????????????????????.........??????????????????????????W"
   "W???????????????????????????.........??????????????????????????W"
   "W???????????????????????????..#####..??????????????????????????W"
   "W???????????????????????????..#.<.#..??????????????????????????W"
   "W???????????????????????????..#}.}#..??????????????????????????W"
   "W???????????????????????????..#.}.#..??????????????????????????W"
   "W???????????????????????????..##.##..??????????????????????????W"
   "W???????????????????????????.........??????????????????????????W"
   "W???????????????????????????.........??????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(WILDERNESS,     0,
	64, 20,
 {@"%%%%%%::::::::::::::::::::%%%%%::^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
   "%%%%%%%%%%%%:::%%%%%%::%%%%%%%%%%^^^^^%%%%%%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%%%%%%%%%%%%%%%%%%%%%%%%::%%%%%^^^^%%%%%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%%::V:%%%%%%::::%%%%&&&:::::^^^^^^^%%%%%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%:::_______________a&&&&:::::^^^^^^^%%%%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%%:::::::::::::::::a&&&:::::::^^%^^^^%%%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%%::::::::::::::::%%%%B%%%::%%%%^^^^^^^%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%%%%%%%%%:::::%%%%%%::_::%%%%%^^^^c:V^^%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%%%%%%%%%%%%%%%%::::::_::::%%:::c^^:::^%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%%::::::%%%%%%:::::::__::::::::::^^^^c^%%%%%%%%%%%%%%%%%%%%^"
   "%%%%%:::::::::::::::::::__:::::::::::^^^^^^%%%%%%%%%%%%%%%%%%%%^"
   "%%%%:::::::::::::::::::V_::::::::::::^^^^%%%%%%%%%%%%%%%%%%%%%%^"
   "^*::::::::::::::::::::::::::::::::::^^^^^%%%%%%%%%%%%%%%%%%%%%%^"
   "^^:::::::::::::::::::::::::::::::::^^^^^%%%%%%%%%%%%%%%%%%%%%%%^"
   "^^:::::::::::::::::::::::::::::::::^^^^^%%%%%%%%%%%%%%%%%%%%%%%^"
   "^^^::::::::::^^^^^^^^^::::^^^^^:::^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
   "^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
   "^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
   "^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
   "^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^"
   @})
//}}}
//{{{
GEN_MAP(MAINTOWN,       1,
	64, 20,
 {@"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
   "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%DD%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
   "%%%%%%%%%%%%%............%%%%%DD%%%.........%%%%%%%%%%%%%%%%%%%%"
   "//W..................................................%%%%%%%%%%%"
   "//W...WWWW...................................................W//"
   "//W...W//W.................WWWW.........WWWWWWfffffWWWWWW....W//"
   "//W...W//W........WWWW.....W//W.........WssssW.....W....W....W//"
   "//W...W=WW........W//=.....W//W.........WssssW.....-....W....W//"
   "//W...............W//W.....WW=W.........WssssW.....W....W....W//"
   "//W......WWWW.....WWWW..................WWW-WW.....WWWWWW....W//"
   "//W......W//=..............WWWW.........F...............F....W//"
   "//W......W//W..............W//W.................}............W//"
   "//W......WWWW....WW=W......W//=.........F...............F....W//"
   "//W..............W//W......WWWW.........WWWWW.......WWWWW....W//"
   "//W..............W//W...................Wsss-.......-sssW....W//"
   "//W..............WWWW...................WsssW.......WsssW....W//"
   "//W.....................................WWWWWfffffffWWWWW....W//"
   "//W.......................WW...WW............................W//"
   "//WWWWWWWWWWWWWWWWWWWWWWWWWWCCCWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW//"
   "////////////////////////////////////////////////////////////////"
 @})
//}}}
//{{{
GEN_MAP(CITY,           1,
	64, 20,
 {@"///WCWWWWWWWWCW//W//WWWWWCW//WCCW//WCWWWWWCWWWWW//WCWWWWWWWCWWWW"
   "WWWW.WiiWiiiW.W//W//WsssW.WWWW..W//W.WiiiW.WiiiWWWW.WiiWii=.W///"
   "WiiW.=iiWiiiW.W=WW=WWsssW.Wii=..W//W.WiiiW.WiiiWiiW.=iiWiiW.=///"
   "Wii=.WWWWiii=.......WsssW.WiiW..=//W.WiiiW.=iiiWii=.WWWWWWW.W///"
   "WiiW.=iiWiiiW.WWWWWWWW-WW.WWWW..WWWW.W=WWW.WWWWWWWW.=iiWii=.W///"
   "WWWW.WiiWiiiW.W....W......WiiW...............W...W..WiiWiiW.WWWW"
   "WiiW.WWWWWWWW.W....W.WWWW.Wii=..WWWW.WWWWWWW.WfffW.WWWWWWWW.W///"
   "Wii=..WiiWiiW.W....W.WiiW.WWWW..WiiW.WiiWiiW.W...W.WiiWiiW..=///"
   "WiiW..=iiWiiW.W....W.WiiW.......WiiW.WiiWiiW.W...W.WiiWiiW..W///"
   "WWWW..WWWWW=W.WW--WW.WW=W.......W=WW.W=WW=WW.WW-WW.W=WWW=W..WWWW"
   "C..............................................................C"
   "C..............................................................C"
   "WWWW.WWWWW..WWWWWW=W.W=WW.......WWWW.W=WW=WW..WW-WWW=W..WWWW=WWW"
   "///=.Wsss-..=iiiWiiW.WiiW.......WiiW.WiiWiiW..W...WiiW..WiiWiiiW"
   "///W.WsssW..WiiiWiiW.WiiW.WWWW..Wii=.WiiWiiW..W...WiiW..=iiWiiiW"
   "///W.WsssWW=WWWWWWWW.WWWW.Wii=..WWWW=WW=W=WW..W.!.WWWWW.WWWWWWWW"
   "WWWW.WWWWWiiiWii=.........WiiW..=iiWiiWiiiiW..WWWWWiiiW.WiiiW///"
   "Wii=.W///WiiiWiiW.WW=W=WW.WWWW..WiiWiiWiiiiW..=///Wiii=.=iiiW///"
   "WiiW.=///WiiiWWWW.W//W//W.W//=..WWWWWWWWWWWW..W///WiiiW.WiiiW///"
   "WWWWCW///WWWWWWWCCW//W//WCW//WCCW//////////WCCW///WWWWWCWWWWW///"
 @})
//}}}
//{{{
GEN_MAP(DWARFTOWN,      0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWWWWWWWWWWW/WW....WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWWssWWWWW////W......WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWsssWWW.W///WW..........WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "WWWWW.WsssW...WWW=W.............WWWWWWWWWWWWWWWWWWWWW//WW///WWWW"
   "WWW...WW-WW......................WWWWWW/////W//W//WW////W////WWW"
   "WW.....................WWWWWW...WWW//WW/////W//W///W////W////WWW"
   "W...........WWW.......WWW///W...WW////WW//WWW=WW//WWW=WWWW=WWWWW"
   "C......WW..WWWW-WW...WW/////W....=////WW=WW....WW=W..........WWW"
   "C......WW..WW...WW...WW///WWW...WWWWWWW.....................WWWW"
   "WW.........W....W.....WW=WW......WWW.......WWWW...W=WWWW=WW.WWWW"
   "WWW........WWWWWW..........................W//WW..W//WW///W.WWWW"
   "WWW........................................=//WW..W//WW///WWWWWW"
   "WW.............................WW-WW.......WWWWW..WWWWW//WWWWWWW"
   "W.......WWWWWWW................W...W.......=//WW..=//WWWWWWWWWWW"
   "C...WWWWWWWWWWWWWWWWWW......WWWW...WWWWWWWWW//WWWWW///WWWWWWWWWW"
   "C...WWWWWWWWWWWWWWWWWWW...WWWWWW.!.WWWWWWWWWWWWWWWW///WWWWWWWWWW"
   "CCCWWWWWWWWWWWWWWWWWWWWCCCWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(FOREST,         0,
	64, 25,
 {@"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
   "%%%%%%%%%......................................................T"
   "//CTTT....?????????????????????????????????????????????????????T"
   "//CT???????????????????????????????????????????????????????????T"
   "//CT???????????????????????????????????????????????????????????T"
   "RRR_???????????????????????????????????????????????????????????T"
   "RRR_???????????????????????????????????????????????????????????T"
   "/CTT???????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CT????????????????????????????????????????????????????????????T"
   "/CC????????????????????????????????????????????????????????????T"
   "//C.???????????????????????????????????????????????????????????T"
   "//C.???????????????????????????????????????????????????????????T"
   "//CTT??????????????????????????????????????????????....????????T"
   "//CCTT???????????????????????????????????????????%%%DD%%%??????T"
   "///CCT????????????????%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%DD%%%%%%%%%%"
   "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%..%%%%%%%%%%"
   "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%CC%%%%%%%%%%"
 @})
//}}}
//{{{
GEN_MAP(CAVE_LEFT,      0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "C..????????????????????????????????????????????????????????????W"
   "C..????????????????????????????????????????????????????????????W"
   "C..????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(CAVE_RIGHT,     0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W?????????????????????????????????????????????????????????????.C"
   "W?????????????????????????????????????????????????????????????.C"
   "W?????????????????????????????????????????????????????????????.C"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(CAVE_DOWN,      0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W?????????????????????????????...??????????????????????????????W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWCCCWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(CAVE_JUNCT_N_W, 0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWCCCWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W?????????????????????????????...??????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "C.?????????????????????????????????????????????????????????????W"
   "C.?????????????????????????????????????????????????????????????W"
   "C.?????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "W??????????????????????????????????????????????????????????????W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER1, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW..W..WWWWWWWW"
   "WWWWW.....W.....WWWWW"
   "WWW.......W.......WWW"
   "WWW.......W.......WWW"
   "WW........W........WW"
   "WW........W........WW"
   "WW......WWWWW......WW"
   "W......WW...WW......W"
   "W......+.....+......W"
   "WWWWWWWW.....WWWWWWWW"
   "W......+.....+......W"
   "W......WW...WW......W"
   "WW......WWWWW......WW"
   "WW........W........WW"
   "WW........W........WW"
   "WWW.......W.......WWW"
   "WWW.......W.......WWW"
   "WWWWW.....W.....WWWWW"
   "WWWWWWWW..W..WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER2, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW..W..WWWWWWWW"
   "WWWWW.....W.....WWWWW"
   "WWW.......W.......WWW"
   "WWW.......W.......WWW"
   "WW........W........WW"
   "WW........W........WW"
   "WWWWWW+WWWWWWW+WWWWWW"
   "W.........W.........W"
   "W.........W.........W"
   "W.........+.........W"
   "W.........W.........W"
   "W.........W.........W"
   "WWWWWW+WWWWWWW+WWWWWW"
   "WW........W........WW"
   "WW........W........WW"
   "WWW.......W.......WWW"
   "WWW.......W.......WWW"
   "WWWWW.....W.....WWWWW"
   "WWWWWWWW..W..WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER3, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWW...........WWWWW"
   "WWW...............WWW"
   "WWW...............WWW"
   "WW.................WW"
   "WWW.....WW+WW.....WWW"
   "W.+....WW...WW....+.W"
   "WWW...WW.....WW...WWW"
   "W.+...W.......W...+.W"
   "WWW...+.......+...WWW"
   "W.+...W.......W...+.W"
   "WWW...WW.....WW...WWW"
   "W.+....WW...WW....+.W"
   "WWW.....WW+WW.....WWW"
   "WW.................WW"
   "WWW...............WWW"
   "WWW...............WWW"
   "WWWWW...........WWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER4, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW.W.W.WWWWWWWW"
   "WWWWW....W.W....WWWWW"
   "WWW......W.W......WWW"
   "WWW......W.W......WWW"
   "WW.......+.+.......WW"
   "WW.......W.W.......WW"
   "WW.......W.W.......WW"
   "W........W.W........W"
   "WWWWW+WWWW.WWWW+WWWWW"
   "W...................W"
   "WWWWW+WWWW.WWWW+WWWWW"
   "W........W.W........W"
   "WW.......W.W.......WW"
   "WW.......W.W.......WW"
   "WW.......W.W.......WW"
   "WWW......+.+......WWW"
   "WWW......W.W......WWW"
   "WWWWW....W.W....WWWWW"
   "WWWWWWWW.W.W.WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER5, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWW...........WWWWW"
   "WWW...............WWW"
   "WWW...............WWW"
   "WW.................WW"
   "WW.................WW"
   "WW.................WW"
   "W...................W"
   "W...................W"
   "W...................W"
   "W...................W"
   "W...................W"
   "WW.................WW"
   "WW.................WW"
   "WW.................WW"
   "WWW...............WWW"
   "WWW...............WWW"
   "WWWWW...........WWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER6, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWW..W.....+..WWWWW"
   "WWW....W.....W....WWW"
   "WWW....W.....W....WWW"
   "WW.....W.....W.....WW"
   "WW.....W.....W.....WW"
   "WW+WWWWWWW+WWWWWWWWWW"
   "W......W.....W......W"
   "W......W.....W......W"
   "W......+.....+......W"
   "W......W.....W......W"
   "W......W.....W......W"
   "WWWWWWWWWW+WWWWWWW+WW"
   "WW.....W.....W.....WW"
   "WW.....W.....W.....WW"
   "WWW....W.....W....WWW"
   "WWW....W.....W....WWW"
   "WWWWW..+.....W..WWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER7, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW..W..WWWWWWWW"
   "WWWWW.....W.....WWWWW"
   "WWW.......W.......WWW"
   "WWW.......W.......WWW"
   "WW........+........WW"
   "WW........W........WW"
   "WW........W........WW"
   "W.........W.........W"
   "W.........W.........W"
   "WWWWW+WWWWWWWWW+WWWWW"
   "W.........W.........W"
   "W.........W.........W"
   "WW........W........WW"
   "WW........W........WW"
   "WW........+........WW"
   "WWW.......W.......WWW"
   "WWW.......W.......WWW"
   "WWWWW.....W.....WWWWW"
   "WWWWWWWW..W..WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER8, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWW..W.....W..WWWWW"
   "WWW....W.....W....WWW"
   "WWW....WWW+WWW....WWW"
   "WW.....+.....+.....WW"
   "WWWWWWWW.....WWWWWWWW"
   "WW...W.........W...WW"
   "W....+.........+....W"
   "W....W.........W....W"
   "WWWWWW.........WWWWWW"
   "W....W.........W....W"
   "W....+.........+....W"
   "WW...W.........W...WW"
   "WWWWWWWW.....WWWWWWWW"
   "WW.....+.....+.....WW"
   "WWW....WWW+WWW....WWW"
   "WWW....W.....W....WWW"
   "WWWWW..W.....W..WWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(TOWER_TOP, 0,
	21, 21,
 {@"WWWWWWWWWWWWWWWWWWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWW..W..<..W..WWWWW"
   "WWW....W.....W....WWW"
   "WWW....WWW+WWW....WWW"
   "WW.....+.....+.....WW"
   "WWWWWWWW.....WWWWWWWW"
   "WW...W.........W...WW"
   "W....W.........+....W"
   "W....W.........W....W"
   "W....=.........WWWWWW"
   "W....W.........W....W"
   "W....W.........+....W"
   "WW...W.........W...WW"
   "WWWWWWWW.....WWWWWWWW"
   "WW.....+.....+.....WW"
   "WWW....WWW+WWW....WWW"
   "WWW....W.....W....WWW"
   "WWWWW..W.....W..WWWWW"
   "WWWWWWWW.....WWWWWWWW"
   "WWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}

//{{{
GEN_MAP(TOWER_ROOF, 1,
	21, 21,
 {@"AAAAAAAAAAAAAAAAAAAAA"
   "AAAAAAAA.....AAAAAAAA"
   "AAAAA.....>.....AAAAA"
   "AAA...............AAA"
   "AAA...............AAA"
   "AA.................AA"
   "AA.................AA"
   "AA.................AA"
   "A...................A"
   "A...................A"
   "A...................A"
   "A...................A"
   "A...................A"
   "AA.................AA"
   "AA.................AA"
   "AA.................AA"
   "AAA...............AAA"
   "AAA...............AAA"
   "AAAAA...........AAAAA"
   "AAAAAAAA.....AAAAAAAA"
   "AAAAAAAAAAAAAAAAAAAAA"
 @})
//}}}
//{{{
GEN_MAP(DRAGONCAVE,     0,
	64, 20,
 {@"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????..##W"
   "W?????????????????????????????????????????????????????????.....C"
   "W?????????????????????????????????????????????????????????.....C"
   "W??????????????????????????????????????????????????????????....C"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "W??????????????????????????????????????????????????????????####W"
   "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW"
 @})
//}}}
//{{{
GEN_MAP(BIGROOM1,       1,
	64, 20,
 {@"????????????????????????????????????????????????????????????????"
   "????????????????????????????????????????????????????????????????"
   "????????WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW????????"
   "??????WWW..............................................WWW??????"
   "?????WW..................................................WW?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????W....................................................W?????"
   "?????WW..................................................WW?????"
   "??????WWW..............................................WWW??????"
   "????????WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW????????"
   "????????????????????????????????????????????????????????????????"
   "????????????????????????????????????????????????????????????????"
 @})
//}}}
//{{{
GEN_MAP(BIGROOM2,       1,
	64, 20,
 {@"????????????????????????????????????????????????????????????????"
   "????????????????????????????????????????????????????????????????"
   "?????WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW?????"
   "?????W....................................................W?????"
   "?????WW..................................................WW?????"
   "??????W..................................................W??????"
   "??????WW................................................WW??????"
   "???????W................................................W???????"
   "???????W................................................W???????"
   "???????W................................................W???????"
   "???????W................................................W???????"
   "???????W................................................W???????"
   "???????W................................................W???????"
   "??????WW................................................WW??????"
   "??????W..................................................W??????"
   "?????WW..................................................WW?????"
   "?????W....................................................W?????"
   "?????WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW?????"
   "????????????????????????????????????????????????????????????????"
   "????????????????????????????????????????????????????????????????"
 @})
//}}}
//{{{
GEN_MAP(BIGROOM3,       1,
	64, 20,
 {@"????????????????????????????????????????????????????????????????"
   "???????????WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW????????????"
   "????????WWWW.......................................WWWW?????????"
   "??????WWW.............................................WWW???????"
   "?????WW.................................................WW??????"
   "?????W...................................................W??????"
   "????WW...................................................WW?????"
   "????W.........WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW.........W?????"
   "????W........WW?????????????????????????????????WW........W?????"
   "????W........W???????????????????????????????????W........W?????"
   "????W........WW?????????????????????????????????WW........W?????"
   "????W.........WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW.........W?????"
   "????W.....................................................W?????"
   "????WW...................................................WW?????"
   "?????W...................................................W??????"
   "?????WW.................................................WW??????"
   "??????WWW.............................................WWW???????"
   "????????WWWW.......................................WWWW?????????"
   "???????????WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW????????????"
   "????????????????????????????????????????????????????????????????"
 @})
//}}}

//{{{
void fill_shop(int left, int right, int top, int bottom, int type)
{
	int xi;
	int yi;
	int pos;
	struct tile *t;
	
	for(yi = top; yi <= bottom; yi++)
	for(xi = left; xi <= right; xi++)
	{
		t = &get_w()->t[yi][xi];
		if(t->type == TILE_FLOOR || t->type == TILE_SHOPFLOOR)
		{
			t->type = TILE_SHOPFLOOR;
			t->special = type;
			
			pos = top_item(xi, yi);
			while(pos)
			{
				get_w()->items.items[pos].flags |= ITEMFLAG_UNPAID;
				pos = get_w()->items.items[pos].next;
			}
		}
	}
}
//}}}
//{{{
void item_on_floor(int x, int y, int type, int qty, int flags, int plus)
{
	char buf[64]; //HACKHACK - workaround for inability to put structs on the
				  // stack directly
	struct item *itm = buf;
	
	itm->type = type; itm->next = 0; itm->stacksize = qty;
	itm->flags = flags; itm->plus = plus; itm->hotkey = 0;
	itm->rustiness = 0;
	
	place_item(itm, x, y);
}
//}}}
//{{{
void stock_item(int x, int y, int type, int qty)
{
	if(!(get_w()->t[y][x].flags & TFLAG_ITEM) &&
	   get_w()->t[y][x].type == TILE_SHOPFLOOR)
	{
		item_on_floor(x, y, type, qty, ITEMFLAG_UNPAID, 0);
	}
}
//}}}
//{{{
void identify_spot(int x, int y)
{
	int pos;
	struct tile *t;
	
	t = &get_w()->t[y][x];
	pos = top_item(x, y);
	while(pos)
	{
		get_w()->items.items[pos].flags |= ITEMFLAG_IDENTIFIED;
		pos = get_w()->items.items[pos].next;
	}
}
//}}}
//{{{
void place_trap(int x, int y)
{
	int trap_type;
	
	if(get_w()->level >= 3) // No traps on first two levels
	{
		get_w()->t[y][x].flags |= TFLAG_HIDETRAP;
		
		trap_type = random(3, 1);
		
		if(trap_type <= 1 && get_w()->level >= 6)
			get_w()->t[y][x].type = TILE_FLAMETRAP;
		else if(trap_type <= 2 && get_w()->level >= 4)
			get_w()->t[y][x].type = TILE_DARTTRAP;
		else
			get_w()->t[y][x].type = TILE_PITTRAP;
	}
}
//}}}
//{{{
void place_traps(void)
{
	int yi;
	int xi;
	
	for(yi=0; yi<MAPSIZE_Y; yi++)
	for(xi=0; xi<MAPSIZE_X; xi++)
	{
		if(get_w()->t[yi][xi].type==TILE_FLOOR)
		{
			// 1 in 100 chance for a trap per tile
			if(random(100, 0) == 0) {
				place_trap(xi, yi);
			}
		}
	}
}
//}}}

//{{{
void populate_map()
{
	int i;
	int j;
	
	place_traps();
	make_connections();
	place_items();
	
	for(i=0; i<MAPSIZE_Y; i++)
	for(j=0; j<MAPSIZE_X; j++)
		get_w()->t[i][j].flags &= ~(TFLAG_MUTABLE | TFLAG_TEMP);
}
//}}}

//{{{
void build_cave()
{
	int ii;
	
	do
	{
		base_coat();
		
		make_noise(TILE_FLOOR, TILE_WALL);
		
		for(ii=0; ii<7; ii++)
			cave_generation(TILE_FLOOR, TILE_WALL);
		
		if(!place_corridors())
			continue;
		
		break;
	} while(1);
	
	populate_map();
}
//}}}
//{{{
void build_mine()
{
	int n = random(10,5);
	int i;
	int x; int y;
	build_cave();
	
	// Add chunks of illuminyte (Return to Zork reference) around the level
	for(i=0; i<n; i++)
	{
		do {
			x = random(MAPSIZE_X-2, 1);
			y = random(MAPSIZE_Y-2, 1);
		} while( tile_is_passable(x, y) );
		item_on_floor(x, y, ITEM_ILLUMINYTE, 1, 0, 0);
	}
}
//}}}
//{{{
void build_dungeon(int num_rooms, int num_holes)
{
	int ii;
	int i;
	int j;
	char rooms[8*20];
	
	do
	{
		base_coat();
		
		for(ii=0; ii<10; ii++) {
			if(!place_room(&rooms[ii*8]))
				continue;
		}
		
		for(ii=0; ii<10; ii++)
			place_hole();
		
		if(!place_corridors())
			continue;
		
		break;
	} while(1);
	
	place_doors();
	
	for(ii=0; ii<10; ii++)
		fill_room(&rooms[8*ii]);
	
	populate_map();
}
//}}}
//{{{
void build_forest()
{
	int i;
	int j;
	
	do
	{
		base_coat();
		make_noise(TILE_FLOOR, TILE_TREE);
		cave_partial_gen(TILE_FLOOR, TILE_TREE);
		
		if(!place_corridors())
			continue;
		
		break;
	} while(1);
	
	make_connections();
	place_items();
		
	for(i=0; i<MAPSIZE_Y; i++)
	for(j=0; j<MAPSIZE_X; j++)
		get_w()->t[i][j].flags &= ~TFLAG_MUTABLE;
}
//}}}
//{{{
void build_city()
{
	base_coat();
	make_connections();
	
	fill_shop(21, 23, 1, 3, 1);
	fill_shop(6, 8, 13, 15, 5);
	stock_item(6, 13, ITEM_POTION_WATER, 3);
	stock_item(6, 15, ITEM_RATTLESNAKE_TOOTH, 6);
}
//}}}
//{{{
void build_dwarftown()
{
	base_coat();
	make_connections();
	fill_shop(7, 9, 4, 6, 7);
	stock_item(7, 5, ITEM_TOOL_TORCH, 900);
	stock_item(8, 5, ITEM_TOOL_LANTERN, 1);
	stock_item(9, 5, ITEM_TOOL_PICKAXE, 1);
	stock_item(8, 4, ITEM_TOOL_PICKAXE, 1);
	stock_item(9, 4, ITEM_ARMR_DWARFISH, 1);
	identify_spot(9, 4);
}
//}}}
//{{{
void build_wilderness()
{
	base_coat();
	make_connections();
	
	// Remove quest entrances inappropriate to the player class
	if( get_w()->plr.class != CLASS_FIGHTER ) {
		get_w()->t[12][1].type = TILE_MOUNT1;
	}
	if( get_w()->plr.class != CLASS_WIZARD &&
	    get_w()->plr.class != CLASS_NECROMANCER ) {
		get_w()->t[12][1].type = TILE_PLAINS;
	}
}
//}}}
//{{{
void build_tower()
{
	struct spec_descriptor *specs;
	int ii;
	int selection;
	int xi;
	int yi;
	specs = &(get_w()->current_map->ext);
	
	base_coat();
	make_connections();
	
	for(ii=0; ii<get_w()->current_map->numspecial; ii++)
	{
		if(specs[ii].type == MAPSPEC_USER1) // Stair DOWN
		{
			get_w()->t[ get_w()->plr.y ][ get_w()->plr.x ].type = TILE_STAIRDN;
			get_w()->t[ get_w()->plr.y ][ get_w()->plr.x ].special = ii;
		}
		else if(specs[ii].type == MAPSPEC_USER2) // Stair UP
		{
			do {
				selection = random(4, 0);
				if     (selection==0) { xi=4;  yi=4;  }
				else if(selection==1) { xi=16; yi=4;  }
				else if(selection==2) { xi=4;  yi=16; }
				else if(selection==3) { xi=16; yi=16; }
				else                  { xi=10; yi=10; }
			} while( get_w()->t[yi][xi].type!=TILE_FLOOR );
			
			get_w()->t[yi][xi].type = TILE_STAIRUP;
			get_w()->t[yi][xi].special = ii;
		}
	}
}
//}}}
//{{{
void build_tower_top()
{
	build_tower();
}
//}}}
//{{{
void build_tower_roof()
{
	base_coat();
	make_connections();
}
//}}}

//{{{
void enter_level()
{
	int ii;
	
	// There are no allies for a lich
	if(get_plr()->class == CLASS_LICH) {
		for(ii=0; ii<MONSTERS_MAX; ii++)
			get_w()->m[ii].flags &= ~(MONST_PEACEFUL|MONST_FRIENDLY);
		clear_shops();
	}
}
//}}}
//{{{
void enter_town()
{
	enter_level();
	
	if(!get_w()->game_flags[ENTERED_MAIN_TOWN])
	{
		message(gettext("You arrive by boat at a port town."));
		fill_shop(41, 44, 6,  8,  6);
		fill_shop(41, 43, 14, 15, 3);
		fill_shop(53, 55, 14, 15, 0);
		get_w()->game_flags[ENTERED_MAIN_TOWN] = 1;
	}
	stock_item(41, 6, ITEM_ARMR_MDSHIELD, 1);
	stock_item(41, 7, ITEM_ARMR_CHAIN, 1);
	stock_item(42, 6, ITEM_FOOD_RATION, 1);
	stock_item(42, 7, ITEM_FOOD_RATION, 1);
	stock_item(43, 6, ITEM_FOOD_RATION, 1);
	stock_item(43, 7, ITEM_FOOD_RATION, 1);
	stock_item(44, 6, ITEM_WEAPON_SWORD, 1);
	stock_item(44, 7, ITEM_ARMR_IRONHELM, 1);
	stock_item(44, 8, ITEM_TOOL_TORCH, 900);
	
	stock_item(41, 14, ITEM_AMMO_ARROW, 15);
	stock_item(41, 15, ITEM_AMMO_BOLT, 10);
	stock_item(42, 14, ITEM_AMMO_ARROW, 15);
	stock_item(42, 15, ITEM_WEAPON_BOW, 1);
	
	stock_item(54, 14, ITEM_GEM_AMETHYST, 1);
	stock_item(54, 15, ITEM_GEM_AGATE, 1);
	stock_item(55, 14, ITEM_GEM_JASPER, 1);
	stock_item(55, 15, ITEM_GEM_TOPAZ, 1);
}
//}}}
//{{{
void enter_wilderness()
{
	enter_level();
	
	if(get_plr()->extrinsic[STAT_COMPONENTS] & STAT_COMPONENT_AM_YENDOR)
	{
		message(gettext("Congratulations! You have escaped with the Amulet."));
		get_plr()->score += 50000;
		end_game(gettext("Escaped with the Amulet."));
	}
	
	// If a fighter, open up the corresponding quest
}
//}}}
//{{{
void enter_forest()
{
	int d[1]; // HACKHACK: Can't put a proper struct on the stack yet, but
	          // this is the same size so it works the same
	
	enter_level();
	
	if(GFLAG(QUEST_TROLL) == QUEST_TROLL_GIVEN)
	{
		GFLAG(QUEST_TROLL) = QUEST_TROLL_SPAWNED;
		get_misc_link(LINK_BRIDGE_TROLL, d);
		addmonster(d, 53, 21);
	}
	GFLAG(TROLL_PAID) = 0;
}
//}}}
//{{{
void enter_dragon_lair()
{
	int d[1]; // HACKHACK: Can't put a proper struct on the stack yet, but
			  // this is the same size so it works the same
	int xi;
	int yi;
	
	enter_level();
	
	message(gettext("The air in this cave is smoky and stifling."));
	message(gettext("The entrance is blocked by debris."));
	if(GFLAG(QUEST_DRAGON_STATUS) == 0) {
		message(gettext("You feel like going in here is a bad idea."));
	} else {
		message(gettext("Perhaps you could dig through it."));
	}
	
	if(GFLAG(QUEST_DRAGON_INCAVE)==0)
	{
		// Place the dragon on the leftmost floor tile
		GFLAG(QUEST_DRAGON_INCAVE) = 1;
		for(xi=1; xi<MAPSIZE_X; xi++)
		{
			for(yi=1; yi<MAPSIZE_Y; yi++)
			{
				if(get_w()->t[yi][xi].type == TILE_FLOOR)
				{
					get_misc_link(LINK_DRAGON, d);
					addmonster(d, xi, yi);
					break(2);
				}
			}
		}
		// Block the entrance
		for(yi=7; yi<=10; yi++)
			get_w()->t[yi][59].type = TILE_WALL;
	}
}
//}}}
//{{{
void enter_wizards_tower()
{
	enter_level();
	
	message(gettext("You enter a strange, abandoned tower."));
}
//}}}
//{{{
void enter_tower_roof()
{
	enter_level();
	
	message(gettext("You step out onto the roof of the tower. There's no railing, and it's a long way down from here."));
}
//}}}

//{{{
void map_normal_dungeon()
{
	build_dungeon(10, 10);
}
//}}}
//{{{
void map_big_dungeon()
{
	int ret;
	do
	{
		base_coat();
		ret = mkmap_big();
	} while(ret==0);
	place_traps();
	make_connections();
	place_items();
}
//}}}
//{{{
void map_packed_dungeon()
{
	build_dungeon(16, 8);
}
//}}}
//{{{
void map_cave()
{
	build_cave();
}
//}}}
//{{{
void map_fixed()
{
	base_coat();
	make_connections();
}
//}}}
//{{{
void map_fixed_layout()
{
	base_coat();
	place_traps();
	make_connections();
	place_items();
}
//}}}
//{{{
void map_fixed_all()
{
	base_coat();
	make_connections();
}
//}}}
//{{{
void map_oracle()
{
	build_dungeon(8, 10);
}
//}}}
//{{{
void map_forest()
{
	build_dungeon(8, 10);
}
//}}}

//{{{
void map_bigroom()
{
	message(gettext("You enter a massive stone cavern."));
	map_fixed_layout();
}
//}}}
//{{{
void map_ruined_town()
{
	message(gettext("The remains of this underground city are abandoned and overrun."));
	map_fixed_all();
}
//}}}


