#! /bin/sh

PATH=/usr/bin
DAEMON=/usr/bin/cachetts.py
DAEMONBIN=cachetts.py
NAME=cachetts
DESC="DBus text to speach daemon"

test -x $DAEMON || exit 0

export PATH="${PATH:+$PATH:}/usr/sbin:/sbin"

case "$1" in
  start)
	echo -n "Starting $DESC: "
	start-stop-daemon --chuid user --start -b --quiet \
		--exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	pkill $DAEMONBIN
	echo "$NAME."
	;;
  force-reload)
	# check wether $DAEMON is running. If so, restart
	pgrep cachetts.py && $0 restart \
	|| exit 0
	;;
  restart)
    echo -n "Restarting $DESC: "
	pkill $DAEMONBIN
	sleep 1
        start-stop-daemon --chuid user --start -b --quiet \
                --exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
